/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.osgi.bundles.test;

import com.ning.billing.catalog.api.Currency;
import com.ning.billing.payment.api.PaymentMethodPlugin;
import com.ning.billing.payment.plugin.api.PaymentInfoPlugin;
import com.ning.billing.payment.plugin.api.PaymentMethodInfoPlugin;
import com.ning.billing.payment.plugin.api.PaymentPluginApiException;
import com.ning.billing.payment.plugin.api.PaymentPluginApiWithTestControl;
import com.ning.billing.payment.plugin.api.PaymentPluginStatus;
import com.ning.billing.payment.plugin.api.RefundInfoPlugin;
import com.ning.billing.payment.plugin.api.RefundPluginStatus;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.TenantContext;
import com.ning.billing.util.entity.Pagination;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPaymentPluginApi
implements PaymentPluginApiWithTestControl {
    private final String name;
    private PaymentPluginApiException paymentPluginApiExceptionOnNextCalls;
    private RuntimeException runtimeExceptionOnNextCalls;

    public TestPaymentPluginApi(String name) {
        this.name = name;
        this.resetToNormalbehavior();
    }

    public PaymentInfoPlugin processPayment(UUID accountId, UUID kbPaymentId, UUID kbPaymentMethodId, final BigDecimal amount, final Currency currency, CallContext context) throws PaymentPluginApiException {
        return this.withRuntimeCheckForExceptions(new PaymentInfoPlugin(){

            public BigDecimal getAmount() {
                return amount;
            }

            public Currency getCurrency() {
                return currency;
            }

            public DateTime getCreatedDate() {
                return new DateTime();
            }

            public DateTime getEffectiveDate() {
                return new DateTime();
            }

            public PaymentPluginStatus getStatus() {
                return PaymentPluginStatus.PROCESSED;
            }

            public String getGatewayError() {
                return null;
            }

            public String getGatewayErrorCode() {
                return null;
            }

            public String getFirstPaymentReferenceId() {
                return null;
            }

            public String getSecondPaymentReferenceId() {
                return null;
            }
        });
    }

    public PaymentInfoPlugin getPaymentInfo(UUID accountId, UUID kbPaymentId, TenantContext context) throws PaymentPluginApiException {
        final BigDecimal someAmount = new BigDecimal("12.45");
        return this.withRuntimeCheckForExceptions(new PaymentInfoPlugin(){

            public BigDecimal getAmount() {
                return someAmount;
            }

            public Currency getCurrency() {
                return null;
            }

            public DateTime getCreatedDate() {
                return new DateTime();
            }

            public DateTime getEffectiveDate() {
                return new DateTime();
            }

            public PaymentPluginStatus getStatus() {
                return PaymentPluginStatus.PROCESSED;
            }

            public String getGatewayError() {
                return null;
            }

            public String getGatewayErrorCode() {
                return null;
            }

            public String getFirstPaymentReferenceId() {
                return null;
            }

            public String getSecondPaymentReferenceId() {
                return null;
            }
        });
    }

    public RefundInfoPlugin processRefund(UUID accountId, UUID kbPaymentId, BigDecimal refundAmount, Currency currency, CallContext context) throws PaymentPluginApiException {
        BigDecimal someAmount = new BigDecimal("12.45");
        return this.withRuntimeCheckForExceptions(new RefundInfoPlugin(){

            public BigDecimal getAmount() {
                return null;
            }

            public Currency getCurrency() {
                return null;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getEffectiveDate() {
                return null;
            }

            public RefundPluginStatus getStatus() {
                return null;
            }

            public String getGatewayError() {
                return null;
            }

            public String getGatewayErrorCode() {
                return null;
            }

            public String getReferenceId() {
                return null;
            }
        });
    }

    public List<RefundInfoPlugin> getRefundInfo(UUID kbAccountId, UUID kbPaymentId, TenantContext context) {
        return Collections.emptyList();
    }

    public void addPaymentMethod(UUID kbAccountId, UUID kbPaymentMethodId, PaymentMethodPlugin paymentMethodProps, boolean setDefault, CallContext context) throws PaymentPluginApiException {
    }

    public void deletePaymentMethod(UUID accountId, UUID kbPaymentMethodId, CallContext context) throws PaymentPluginApiException {
    }

    public PaymentMethodPlugin getPaymentMethodDetail(UUID kbAccountId, UUID kbPaymentMethodId, TenantContext context) throws PaymentPluginApiException {
        return null;
    }

    public void setDefaultPaymentMethod(UUID accountId, UUID kbPaymentMethodId, CallContext context) throws PaymentPluginApiException {
    }

    public List<PaymentMethodInfoPlugin> getPaymentMethods(UUID kbAccountId, boolean refreshFromGateway, CallContext context) throws PaymentPluginApiException {
        return Collections.emptyList();
    }

    public Pagination<PaymentMethodPlugin> searchPaymentMethods(String searchKey, Long offset, Long limit, TenantContext tenantContext) throws PaymentPluginApiException {
        return new Pagination<PaymentMethodPlugin>(){

            public Long getCurrentOffset() {
                return 0L;
            }

            public Long getNextOffset() {
                return null;
            }

            public Long getMaxNbRecords() {
                return 0L;
            }

            public Long getTotalNbRecords() {
                return 0L;
            }

            public Iterator<PaymentMethodPlugin> iterator() {
                return null;
            }
        };
    }

    public void resetPaymentMethods(UUID accountId, List<PaymentMethodInfoPlugin> paymentMethods) throws PaymentPluginApiException {
    }

    private <T> T withRuntimeCheckForExceptions(T result) throws PaymentPluginApiException {
        if (this.paymentPluginApiExceptionOnNextCalls != null) {
            throw this.paymentPluginApiExceptionOnNextCalls;
        }
        if (this.runtimeExceptionOnNextCalls != null) {
            throw this.runtimeExceptionOnNextCalls;
        }
        return result;
    }

    public void setPaymentPluginApiExceptionOnNextCalls(PaymentPluginApiException e) {
        this.resetToNormalbehavior();
        this.paymentPluginApiExceptionOnNextCalls = e;
    }

    public void setPaymentRuntimeExceptionOnNextCalls(RuntimeException e) {
        this.resetToNormalbehavior();
        this.runtimeExceptionOnNextCalls = e;
    }

    public void resetToNormalbehavior() {
        this.paymentPluginApiExceptionOnNextCalls = null;
        this.runtimeExceptionOnNextCalls = null;
    }
}

