/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.Realm;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.future.StackTraceInspector;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListener
implements ChannelFutureProgressListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressListener.class);
    private final AsyncHttpClientConfig config;
    private final boolean notifyHeaders;
    private final AsyncHandler<?> asyncHandler;
    private final NettyResponseFuture<?> future;

    public ProgressListener(AsyncHttpClientConfig config, AsyncHandler<?> asyncHandler, NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.config = config;
        this.asyncHandler = asyncHandler;
        this.future = future;
        this.notifyHeaders = notifyHeaders;
    }

    public void operationComplete(ChannelFuture cf) {
        boolean startPublishing;
        Throwable cause = cf.getCause();
        if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
            if (cause instanceof IllegalStateException) {
                LOGGER.debug(cause.getMessage(), cause);
                try {
                    cf.getChannel().close();
                }
                catch (RuntimeException ex) {
                    LOGGER.debug(ex.getMessage(), (Throwable)ex);
                }
                return;
            }
            if (cause instanceof ClosedChannelException || StackTraceInspector.abortOnReadOrWriteException(cause)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                }
                try {
                    cf.getChannel().close();
                }
                catch (RuntimeException ex) {
                    LOGGER.debug(ex.getMessage(), (Throwable)ex);
                }
                return;
            }
            this.future.abort(cause);
            return;
        }
        this.future.touch();
        Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : this.config.getRealm();
        boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
        if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
            if (this.notifyHeaders) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
            } else {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
            }
        }
    }

    public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
        this.future.touch();
        if (this.asyncHandler instanceof ProgressAsyncHandler) {
            ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
        }
    }
}

