/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.apache;

import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ResponseBase;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApacheResponse
extends ResponseBase {
    public ApacheResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return AsyncHttpProviderUtils.contentToByte(this.bodyParts);
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.getResponseBodyAsBytes());
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return AsyncHttpProviderUtils.contentToString(this.bodyParts, this.calculateCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return AsyncHttpProviderUtils.contentToInputStream(this.bodyParts);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String response = AsyncHttpProviderUtils.contentToString(this.bodyParts, this.calculateCharset(charset));
        return response.length() <= maxLength ? response : response.substring(0, maxLength);
    }

    @Override
    protected List<Cookie> buildCookies() {
        ArrayList<Cookie> localCookies = new ArrayList<Cookie>();
        for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
            if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            List<String> v = header.getValue();
            for (String value : v) {
                Cookie cookie = CookieDecoder.decode(value);
                localCookies.add(cookie);
            }
        }
        return localCookies;
    }
}

