/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.ProgressListener;
import com.ning.http.client.providers.netty.request.body.NettyBody;
import com.ning.http.client.providers.netty.request.body.OptimizedFileRegion;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyFileBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyFileBody.class);
    public static final int MAX_BUFFERED_BYTES = 8192;
    private final File file;
    private final long offset;
    private final long length;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyFileBody(File file, NettyAsyncHttpProviderConfig nettyConfig) throws IOException {
        this(file, 0L, file.length(), nettyConfig);
    }

    public NettyFileBody(File file, long offset, long length, NettyAsyncHttpProviderConfig nettyConfig) throws IOException {
        if (!file.isFile()) {
            throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.nettyConfig = nettyConfig;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            ChannelFuture writeFuture;
            if (ChannelManager.isSslHandlerConfigured(channel.getPipeline()) || this.nettyConfig.isDisableZeroCopy()) {
                writeFuture = channel.write((Object)new ChunkedFile(raf, 0L, raf.length(), this.nettyConfig.getChunkedFileChunkSize()));
            } else {
                OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, raf.length());
                writeFuture = channel.write((Object)region);
            }
            writeFuture.addListener((ChannelFutureListener)new ProgressListener(config, future.getAsyncHandler(), future, false){

                @Override
                public void operationComplete(ChannelFuture cf) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                    }
                    super.operationComplete(cf);
                }
            });
        }
        catch (IOException ex) {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }
}

