/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Body;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.ProgressListener;
import com.ning.http.client.providers.netty.request.body.BodyChunkedInput;
import com.ning.http.client.providers.netty.request.body.NettyBody;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyInputStreamBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyInputStreamBody.class);
    private final InputStream inputStream;

    public NettyInputStreamBody(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        InputStream is = this.inputStream;
        if (future.isStreamWasAlreadyConsumed()) {
            if (!is.markSupported()) {
                LOGGER.warn("Stream has already been consumed and cannot be reset");
                return;
            }
            is.reset();
        } else {
            future.setStreamWasAlreadyConsumed(true);
        }
        InputStreamBodyGenerator generator = new InputStreamBodyGenerator(is);
        generator.patchNettyChunkingIssue(true);
        final Body body = generator.createBody();
        channel.write((Object)new BodyChunkedInput(body)).addListener((ChannelFutureListener)new ProgressListener(config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                try {
                    body.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                }
                super.operationComplete(cf);
            }
        });
    }
}

