/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseBodyPartsInputStream;
import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class AsyncHttpProviderUtils {
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely closed");
    public static final Charset DEFAULT_CHARSET;
    static final byte[] EMPTY_BYTE_ARRAY;

    public static final void validateSupportedScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }

    public static final String getBaseUrl(Uri uri) {
        return uri.getScheme() + "://" + AsyncHttpProviderUtils.getAuthority(uri);
    }

    public static final String getAuthority(Uri uri) {
        int port = uri.getPort() != -1 ? uri.getPort() : AsyncHttpProviderUtils.getDefaultPort(uri);
        return uri.getHost() + ":" + port;
    }

    public static final String contentToString(List<HttpResponseBodyPart> bodyParts, Charset charset) throws UnsupportedEncodingException {
        return new String(AsyncHttpProviderUtils.contentToByte(bodyParts), charset);
    }

    public static final byte[] contentToByte(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        if (bodyParts.size() == 1) {
            return bodyParts.get(0).getBodyPartBytes();
        }
        int size = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            size += body.getBodyPartBytes().length;
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            byte[] bodyBytes = body.getBodyPartBytes();
            System.arraycopy(bodyBytes, 0, bytes, offset, bodyBytes.length);
            offset += bodyBytes.length;
        }
        return bytes;
    }

    public static final InputStream contentToInputStream(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        return bodyParts.isEmpty() ? new ByteArrayInputStream(EMPTY_BYTE_ARRAY) : new HttpResponseBodyPartsInputStream(bodyParts);
    }

    public static final int getDefaultPort(Uri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") || uri.getScheme().equals("ws") ? 80 : 443;
        }
        return port;
    }

    public static final String getNonEmptyPath(Uri uri) {
        return MiscUtils.isNonEmpty(uri.getPath()) ? uri.getPath() : "/";
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    public static String parseCharset(String contentType) {
        for (String part : contentType.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("=")).length <= 1) continue;
            String charset = val[1].trim();
            return charset.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    public static String keepAliveHeaderValue(AsyncHttpClientConfig config) {
        return config.isAllowPoolingConnections() ? "keep-alive" : "close";
    }

    public static int requestTimeout(AsyncHttpClientConfig config, Request request) {
        return request.getRequestTimeout() != 0 ? request.getRequestTimeout() : config.getRequestTimeout();
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request) {
        return request.getFollowRedirect() != null ? request.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static String formParams2UTF8String(List<Param> params) {
        StringBuilder sb = new StringBuilder(params.size() * 15);
        for (Param param : params) {
            UTF8UrlEncoder.appendEncoded(sb, param.getName());
            sb.append("=");
            UTF8UrlEncoder.appendEncoded(sb, param.getValue());
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
        EMPTY_BYTE_ARRAY = "".getBytes();
    }
}

