/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.BodyChunkedInput;
import com.ning.http.client.providers.netty.BodyFileRegion;
import com.ning.http.client.providers.netty.Channels;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.NettyConnectListener;
import com.ning.http.client.providers.netty.NettyResponse;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.NettyWebSocket;
import com.ning.http.client.providers.netty.Protocol;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.client.providers.netty.ResponseHeaders;
import com.ning.http.client.providers.netty.ResponseStatus;
import com.ning.http.client.providers.netty.SslInitializer;
import com.ning.http.client.providers.netty.WebSocketUtil;
import com.ning.http.client.providers.netty.pool.ChannelManager;
import com.ning.http.client.providers.netty.pool.ChannelPool;
import com.ning.http.client.providers.netty.pool.DefaultChannelPool;
import com.ning.http.client.providers.netty.pool.NoopChannelPool;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.client.providers.netty.timeout.ReadTimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.RequestTimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.multipart.MultipartBody;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.PrematureChannelClosureException;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    public static final String GZIP_DEFLATE = "gzip,deflate";
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely Closed");
    public static final String HTTP_HANDLER = "httpHandler";
    public static final String SSL_HANDLER = "sslHandler";
    public static final String HTTP_PROCESSOR = "httpProcessor";
    public static final String WS_PROCESSOR = "wsProcessor";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String WEBSOCKET = "ws";
    private static final String WEBSOCKET_SSL = "wss";
    private static final Charset UTF8;
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private final ClientBootstrap webSocketBootstrap;
    private final ClientBootstrap secureWebSocketBootstrap;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final boolean allowReleaseSocketChannelFactory;
    private final ChannelManager channelManager;
    private final NettyAsyncHttpProviderConfig providerConfig;
    private final boolean disableZeroCopy;
    private static final NTLMEngine ntlmEngine;
    private static SpnegoEngine spnegoEngine;
    private final Protocol httpProtocol = new HttpProtocol();
    private final Protocol webSocketProtocol = new WebSocketProtocol();
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private final long handshakeTimeoutInMillis;

    private static boolean isNTLM(List<String> auth) {
        return MiscUtils.isNonEmpty(auth) && auth.get(0).startsWith("NTLM");
    }

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        this.providerConfig = config.getAsyncHttpProviderConfig() instanceof NettyAsyncHttpProviderConfig ? (NettyAsyncHttpProviderConfig)config.getAsyncHttpProviderConfig() : new NettyAsyncHttpProviderConfig();
        if (this.providerConfig.getSocketChannelFactory() != null) {
            this.socketChannelFactory = this.providerConfig.getSocketChannelFactory();
            this.allowReleaseSocketChannelFactory = false;
        } else {
            ExecutorService e = this.providerConfig.getBossExecutorService();
            if (e == null) {
                e = Executors.newCachedThreadPool();
            }
            int numWorkers = config.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
            LOGGER.trace("Number of application's worker threads is {}", (Object)numWorkers);
            this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)e, (Executor)config.executorService(), numWorkers);
            this.allowReleaseSocketChannelFactory = true;
        }
        this.allowStopNettyTimer = this.providerConfig.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : this.providerConfig.getNettyTimer();
        this.handshakeTimeoutInMillis = this.providerConfig.getHandshakeTimeoutInMillis();
        this.plainBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.webSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureWebSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.disableZeroCopy = this.providerConfig.isDisableZeroCopy();
        this.configureNetty();
        ChannelPool channelPool = this.providerConfig.getChannelPool();
        if (channelPool == null && config.isAllowPoolingConnections()) {
            channelPool = new DefaultChannelPool(config, this.nettyTimer);
        } else if (channelPool == null) {
            channelPool = new NoopChannelPool();
        }
        this.channelManager = new ChannelManager(config, channelPool);
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    void configureNetty() {
        DefaultChannelFuture.setUseDeadLockChecker((boolean)this.providerConfig.isUseDeadLockChecker());
        for (Map.Entry<String, Object> entry : this.providerConfig.propertiesSet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.plainBootstrap.setOption(key, value);
            this.webSocketBootstrap.setOption(key, value);
            this.secureBootstrap.setOption(key, value);
            this.secureWebSocketBootstrap.setOption(key, value);
        }
        final boolean compressionEnabled = this.config.isCompressionEnabled();
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpClientCodec());
                if (compressionEnabled) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_PROCESSOR, (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        this.webSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpClientCodec());
                pipeline.addLast(NettyAsyncHttpProvider.WS_PROCESSOR, (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslInitializer(NettyAsyncHttpProvider.this));
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpsClientCodec());
                if (compressionEnabled) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_PROCESSOR, (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        this.secureWebSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslInitializer(NettyAsyncHttpProvider.this));
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpsClientCodec());
                pipeline.addLast(NettyAsyncHttpProvider.WS_PROCESSOR, (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
    }

    SslHandler createSslHandler(String peerHost, int peerPort) throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = SslUtils.getInstance().createClientSSLEngine(this.config, peerHost, peerPort);
        return this.handshakeTimeoutInMillis > 0L ? new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, this.nettyTimer, this.handshakeTimeoutInMillis) : new SslHandler(sslEngine);
    }

    private Channel lookupInCache(UriComponents uri, ProxyServer proxy, ConnectionPoolKeyStrategy strategy) {
        Channel channel = this.channelManager.poll(this.getPoolKey(uri, proxy, strategy));
        if (channel != null) {
            LOGGER.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                return this.verifyChannelPipeline(channel, uri.getScheme());
            }
            catch (Exception ex) {
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private HttpClientCodec createHttpClientCodec() {
        return new HttpClientCodec(this.providerConfig.getHttpClientCodecMaxInitialLineLength(), this.providerConfig.getHttpClientCodecMaxHeaderSize(), this.providerConfig.getHttpClientCodecMaxChunkSize());
    }

    private HttpClientCodec createHttpsClientCodec() {
        return new HttpClientCodec(this.providerConfig.getHttpClientCodecMaxInitialLineLength(), this.providerConfig.getHttpClientCodecMaxHeaderSize(), this.providerConfig.getHttpClientCodecMaxChunkSize());
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && NettyAsyncHttpProvider.isSecure(scheme)) {
                channel.getPipeline().addFirst(SSL_HANDLER, (ChannelHandler)new SslInitializer(this));
            }
        }
        return channel;
    }

    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config, NettyResponseFuture<T> future) {
        block41: {
            HttpRequest nettyRequest = future.getNettyRequest();
            HttpHeaders nettyRequestHeaders = nettyRequest.headers();
            boolean ssl = channel.getPipeline().get(SslHandler.class) != null;
            try {
                if (!channel.isOpen() || !channel.isConnected()) {
                    return;
                }
                Body body = null;
                if (!nettyRequest.getMethod().equals((Object)HttpMethod.CONNECT)) {
                    BodyGenerator bg = future.getRequest().getBodyGenerator();
                    if (bg == null && future.getRequest().getStreamData() != null) {
                        bg = new InputStreamBodyGenerator(future.getRequest().getStreamData());
                    }
                    if (bg != null) {
                        if (bg instanceof InputStreamBodyGenerator) {
                            ((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(bg)).patchNettyChunkingIssue(true);
                        }
                        try {
                            body = bg.createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body.getContentLength();
                        if (length >= 0L) {
                            nettyRequestHeaders.set("Content-Length", (Object)length);
                        } else {
                            nettyRequestHeaders.set("Transfer-Encoding", (Object)"chunked");
                        }
                    } else if (MiscUtils.isNonEmpty(future.getRequest().getParts())) {
                        String contentType = nettyRequestHeaders.get("Content-Type");
                        String contentLength = nettyRequestHeaders.get("Content-Length");
                        long length = -1L;
                        if (contentLength != null) {
                            length = Long.parseLong(contentLength);
                        } else {
                            nettyRequestHeaders.add("Transfer-Encoding", (Object)"chunked");
                        }
                        body = new MultipartBody(future.getRequest().getParts(), contentType, length);
                    }
                }
                if (future.getAsyncHandler() instanceof TransferCompletionHandler) {
                    FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
                    for (String s : nettyRequestHeaders.names()) {
                        for (String header : nettyRequestHeaders.getAll(s)) {
                            h.add(s, header);
                        }
                    }
                    ((TransferCompletionHandler)TransferCompletionHandler.class.cast(future.getAsyncHandler())).transferAdapter(new NettyTransferAdapter(h, nettyRequest.getContent(), future.getRequest().getFile()));
                }
                if (future.getAndSetWriteHeaders(true)) {
                    try {
                        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRequestSent();
                        }
                        channel.write((Object)nettyRequest).addListener((ChannelFutureListener)new ProgressListener(true, future.getAsyncHandler(), future));
                    }
                    catch (Throwable cause) {
                        LOGGER.debug(cause.getMessage(), cause);
                        try {
                            channel.close();
                        }
                        catch (RuntimeException ex) {
                            LOGGER.debug(ex.getMessage(), (Throwable)ex);
                        }
                        return;
                    }
                }
                if (!future.getAndSetWriteBody(true) || nettyRequest.getMethod().equals((Object)HttpMethod.CONNECT)) break block41;
                if (future.getRequest().getFile() != null) {
                    File file = future.getRequest().getFile();
                    final RandomAccessFile raf = new RandomAccessFile(file, "r");
                    try {
                        ChannelFuture writeFuture;
                        if (this.disableZeroCopy || ssl) {
                            writeFuture = channel.write((Object)new ChunkedFile(raf, 0L, raf.length(), this.providerConfig.getChunkedFileChunkSize()));
                        } else {
                            OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, raf.length());
                            writeFuture = channel.write((Object)region);
                        }
                        writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                            public void operationComplete(ChannelFuture cf) {
                                try {
                                    raf.close();
                                }
                                catch (IOException e) {
                                    LOGGER.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                                }
                                super.operationComplete(cf);
                            }
                        });
                        break block41;
                    }
                    catch (IOException ex) {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                if (body != null) {
                    ChannelFuture writeFuture;
                    final Body b = body;
                    if (this.disableZeroCopy || ssl || !(body instanceof RandomAccessBody)) {
                        BodyChunkedInput bodyChunkedInput = new BodyChunkedInput(body);
                        writeFuture = channel.write((Object)bodyChunkedInput);
                    } else {
                        BodyFileRegion bodyFileRegion = new BodyFileRegion((RandomAccessBody)body);
                        writeFuture = channel.write((Object)bodyFileRegion);
                    }
                    writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                LOGGER.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                try {
                    channel.close();
                }
                catch (RuntimeException ex) {
                    LOGGER.debug(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        try {
            int readTimeout;
            future.touch();
            int requestTimeout = AsyncHttpProviderUtils.requestTimeout(config, future.getRequest());
            TimeoutsHolder timeoutsHolder = new TimeoutsHolder();
            if (requestTimeout != -1) {
                timeoutsHolder.requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(future, this, timeoutsHolder, requestTimeout), requestTimeout);
            }
            if ((readTimeout = config.getReadTimeout()) != -1 && readTimeout <= requestTimeout) {
                timeoutsHolder.readTimeout = this.newTimeout(new ReadTimeoutTimerTask(future, this, timeoutsHolder, requestTimeout, readTimeout), readTimeout);
            }
            future.setTimeoutsHolder(timeoutsHolder);
        }
        catch (RejectedExecutionException ex) {
            this.abort(future, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, UriComponents uri, boolean allowConnect, ChannelBuffer buffer, ProxyServer proxyServer) throws IOException {
        String method = request.getMethod();
        if (allowConnect && proxyServer != null && NettyAsyncHttpProvider.isSecure(uri)) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(method), uri, buffer, proxyServer);
    }

    private static SpnegoEngine getSpnegoEngine() {
        if (spnegoEngine == null) {
            spnegoEngine = new SpnegoEngine();
        }
        return spnegoEngine;
    }

    private static String computeNonConnectRequestPath(AsyncHttpClientConfig config, UriComponents uri, ProxyServer proxyServer) {
        if (!(proxyServer == null || NettyAsyncHttpProvider.isSecure(uri) && config.isUseRelativeURIsWithSSLProxies())) {
            return uri.toString();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        return uri.getQuery() != null ? path + "?" + uri.getQuery() : path;
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, UriComponents uri, ChannelBuffer buffer, ProxyServer proxyServer) throws IOException {
        String userAgentHeader;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        if (m.equals((Object)HttpMethod.CONNECT)) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, AsyncHttpProviderUtils.getAuthority(uri));
        } else {
            String path = NettyAsyncHttpProvider.computeNonConnectRequestPath(config, uri, proxyServer);
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path);
        }
        HttpHeaders nettyRequestHeaders = nettyRequest.headers();
        boolean webSocket = NettyAsyncHttpProvider.isWebSocket(uri.getScheme());
        if (webSocket && !m.equals((Object)HttpMethod.CONNECT)) {
            nettyRequestHeaders.add("Upgrade", (Object)"WebSocket");
            nettyRequestHeaders.add("Connection", (Object)"Upgrade");
            nettyRequestHeaders.add("Origin", (Object)("http://" + uri.getHost() + ":" + uri.getPort()));
            nettyRequestHeaders.add("Sec-WebSocket-Key", (Object)WebSocketUtil.getKey());
            nettyRequestHeaders.add("Sec-WebSocket-Version", (Object)"13");
        }
        String host = request.getVirtualHost() != null ? request.getVirtualHost() : uri.getHost();
        String hostHeader = request.getVirtualHost() != null || uri.getPort() == -1 ? host : host + ":" + uri.getPort();
        nettyRequestHeaders.set("Host", (Object)hostHeader);
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            for (Map.Entry<String, List<String>> header : request.getHeaders()) {
                String name = header.getKey();
                if ("Host".equalsIgnoreCase(name)) continue;
                for (String value : header.getValue()) {
                    nettyRequestHeaders.add(name, (Object)value);
                }
            }
            if (config.isCompressionEnabled()) {
                nettyRequestHeaders.set("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        } else {
            Object auth = request.getHeaders().get("Proxy-Authorization");
            if (NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                nettyRequestHeaders.add("Proxy-Authorization", auth.get(0));
            }
        }
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            String domain = realm.getNtlmDomain();
            if (proxyServer != null && proxyServer.getNtlmDomain() != null) {
                domain = proxyServer.getNtlmDomain();
            }
            String authHost = realm.getNtlmHost();
            if (proxyServer != null && proxyServer.getHost() != null) {
                host = proxyServer.getHost();
            }
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequestHeaders.add("Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    try {
                        nettyRequestHeaders.add("Authorization", (Object)AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    try {
                        nettyRequestHeaders.add("Authorization", (Object)ntlmEngine.generateType1Msg("NTLM " + domain, authHost));
                        break;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String challengeHeader = null;
                    String server = proxyServer == null ? host : proxyServer.getHost();
                    try {
                        challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
                    }
                    catch (Throwable e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                    nettyRequestHeaders.add("Authorization", (Object)("Negotiate " + challengeHeader));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                }
            }
        }
        if (!webSocket && !request.getHeaders().containsKey("Connection")) {
            nettyRequestHeaders.set("Connection", (Object)AsyncHttpProviderUtils.keepAliveHeaderValue(config));
        }
        if (proxyServer != null) {
            if (!request.getHeaders().containsKey("Proxy-Connection")) {
                nettyRequestHeaders.set("Proxy-Connection", (Object)AsyncHttpProviderUtils.keepAliveHeaderValue(config));
            }
            if (proxyServer.getPrincipal() != null) {
                if (MiscUtils.isNonEmpty(proxyServer.getNtlmDomain())) {
                    Object auth = request.getHeaders().get("Proxy-Authorization");
                    if (!NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                        try {
                            String msg = ntlmEngine.generateType1Msg(proxyServer.getNtlmDomain(), proxyServer.getHost());
                            nettyRequestHeaders.set("Proxy-Authorization", (Object)("NTLM " + msg));
                        }
                        catch (NTLMEngineException e) {
                            IOException ie = new IOException();
                            ie.initCause(e);
                            throw ie;
                        }
                    }
                } else {
                    nettyRequestHeaders.set("Proxy-Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                }
            }
        }
        if (!request.getHeaders().containsKey("Accept")) {
            nettyRequestHeaders.set("Accept", (Object)"*/*");
        }
        if ((userAgentHeader = request.getHeaders().getFirstValue("User-Agent")) != null) {
            nettyRequestHeaders.set("User-Agent", (Object)userAgentHeader);
        } else if (config.getUserAgent() != null) {
            nettyRequestHeaders.set("User-Agent", (Object)config.getUserAgent());
        } else {
            nettyRequestHeaders.set("User-Agent", (Object)AsyncHttpProviderUtils.constructUserAgent(NettyAsyncHttpProvider.class));
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            String bodyCharset;
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                nettyRequestHeaders.set("Cookie", (Object)CookieEncoder.encode(request.getCookies()));
            }
            String string = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
            if (buffer != null && buffer.writerIndex() != 0) {
                nettyRequestHeaders.set("Content-Length", (Object)buffer.writerIndex());
                nettyRequest.setContent(buffer);
            } else if (request.getByteData() != null) {
                nettyRequestHeaders.set("Content-Length", (Object)String.valueOf(request.getByteData().length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])request.getByteData()));
            } else if (request.getStringData() != null) {
                byte[] bytes = request.getStringData().getBytes(bodyCharset);
                nettyRequestHeaders.set("Content-Length", (Object)String.valueOf(bytes.length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])bytes));
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                String formBody = AsyncHttpProviderUtils.formParams2UTF8String(request.getFormParams());
                nettyRequestHeaders.set("Content-Length", (Object)String.valueOf(formBody.length()));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])formBody.getBytes(bodyCharset)));
                if (!request.getHeaders().containsKey("Content-Type")) {
                    nettyRequestHeaders.set("Content-Type", (Object)"application/x-www-form-urlencoded");
                }
            } else if (MiscUtils.isNonEmpty(request.getParts())) {
                MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getHeaders());
                nettyRequestHeaders.set("Content-Type", (Object)mre.getContentType());
                long contentLength = mre.getContentLength();
                if (contentLength >= 0L) {
                    nettyRequestHeaders.set("Content-Length", (Object)String.valueOf(contentLength));
                }
            } else if (request.getFile() != null) {
                File file = request.getFile();
                if (!file.isFile()) {
                    throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
                }
                nettyRequestHeaders.set("Content-Length", (Object)file.length());
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        if (this.isClose.compareAndSet(false, true)) {
            try {
                this.channelManager.destroy();
                this.config.executorService().shutdown();
                if (this.allowReleaseSocketChannelFactory) {
                    this.socketChannelFactory.releaseExternalResources();
                    this.plainBootstrap.releaseExternalResources();
                    this.secureBootstrap.releaseExternalResources();
                    this.webSocketBootstrap.releaseExternalResources();
                    this.secureWebSocketBootstrap.releaseExternalResources();
                }
                if (this.allowStopNettyTimer) {
                    this.nettyTimer.stop();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on close", t);
            }
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(status, headers, bodyParts);
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean reclaimCache) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, reclaimCache);
    }

    private <T> NettyResponseFuture<T> buildNettyResponseFutureWithCachedChannel(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, ProxyServer proxyServer, UriComponents uri, ChannelBuffer bufferedBytes, int maxTry) throws IOException {
        for (int i = 0; i < maxTry; ++i) {
            if (maxTry == 0) {
                return null;
            }
            Channel channel = null;
            channel = f != null && f.reuseChannel() && f.channel() != null ? f.channel() : this.lookupInCache(uri, proxyServer, request.getConnectionPoolKeyStrategy());
            if (channel == null) {
                return null;
            }
            HttpRequest nettyRequest = null;
            if (f == null) {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, bufferedBytes, proxyServer);
                f = NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, this.config, proxyServer);
            } else if (i == 0) {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, f.isConnectAllowed(), bufferedBytes, proxyServer);
                f.setNettyRequest(nettyRequest);
            }
            f.setState(NettyResponseFuture.STATE.POOLED);
            f.attachChannel(channel, false);
            if (channel.isOpen() && channel.isConnected()) {
                Channels.setAttachment(channel, f);
                return f;
            }
            f.attachChannel(null);
        }
        return null;
    }

    private <T> NettyResponseFuture<T> buildConnectListenerFuture(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, ChannelBuffer buffer, UriComponents uri) throws IOException {
        ProxyServer proxyServer = ProxyUtils.getProxyServer(config, request);
        HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(config, request, uri, true, buffer, proxyServer);
        if (future == null) {
            return NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, config, proxyServer);
        }
        future.setNettyRequest(nettyRequest);
        future.setRequest(request);
        return future;
    }

    private <T> ListenableFuture<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, boolean useCache, boolean reclaimCache) throws IOException {
        NettyResponseFuture<T> connectedFuture;
        boolean useSSl;
        if (this.isClose()) {
            throw new IOException("Closed");
        }
        UriComponents uri = request.getURI();
        if (uri.getScheme().startsWith(WEBSOCKET) && !NettyAsyncHttpProvider.validateWebSocketRequest(request, asyncHandler)) {
            throw new IOException("WebSocket method must be a GET");
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean resultOfAConnect = f != null && f.getNettyRequest() != null && f.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT);
        boolean useProxy = proxyServer != null && !resultOfAConnect;
        ChannelBuffer bufferedBytes = null;
        if (f != null && f.getRequest().getFile() == null && !f.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
            bufferedBytes = f.getNettyRequest().getContent();
        }
        boolean bl = useSSl = NettyAsyncHttpProvider.isSecure(uri) && !useProxy;
        if (useCache && (connectedFuture = this.buildNettyResponseFutureWithCachedChannel(request, asyncHandler, f, proxyServer, uri, bufferedBytes, 3)) != null) {
            LOGGER.debug("\nUsing cached Channel {}\n for request \n{}\n", (Object)connectedFuture.channel(), (Object)connectedFuture.getNettyRequest());
            try {
                this.writeRequest(connectedFuture.channel(), this.config, connectedFuture);
            }
            catch (Exception ex) {
                LOGGER.debug("writeRequest failure", (Throwable)ex);
                if (useSSl && ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                    LOGGER.debug("SSLEngine failure", (Throwable)ex);
                    connectedFuture = null;
                }
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    LOGGER.warn("doConnect.writeRequest()", t);
                }
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            return connectedFuture;
        }
        NettyResponseFuture<T> connectListenerFuture = this.buildConnectListenerFuture(this.config, request, asyncHandler, f, bufferedBytes, uri);
        boolean channelPreempted = false;
        String poolKey = null;
        if (!reclaimCache) {
            if (this.config.getMaxConnectionsPerHost() > 0) {
                poolKey = this.getPoolKey(connectListenerFuture);
            }
            if (this.channelManager.preemptChannel(poolKey)) {
                channelPreempted = true;
            } else {
                IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxConnections()));
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Exception e) {
                    LOGGER.warn("asyncHandler.onThrowable crashed", (Throwable)e);
                }
                throw ex;
            }
        }
        NettyConnectListener<T> connectListener = new NettyConnectListener<T>(this.config, connectListenerFuture, this, this.channelManager, channelPreempted, poolKey);
        ClientBootstrap bootstrap = request.getURI().getScheme().startsWith(WEBSOCKET) && !useProxy ? (useSSl ? this.secureWebSocketBootstrap : this.webSocketBootstrap) : (useSSl ? this.secureBootstrap : this.plainBootstrap);
        bootstrap.setOption("connectTimeoutMillis", (Object)this.config.getConnectionTimeout());
        try {
            InetSocketAddress remoteAddress = request.getInetAddress() != null ? new InetSocketAddress(request.getInetAddress(), AsyncHttpProviderUtils.getDefaultPort(uri)) : (!useProxy ? new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getDefaultPort(uri)) : new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
            ChannelFuture channelFuture = request.getLocalAddress() != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0)) : bootstrap.connect((SocketAddress)remoteAddress);
            channelFuture.addListener(connectListener);
        }
        catch (Throwable t) {
            if (channelPreempted) {
                this.channelManager.abortChannelPreemption(poolKey);
            }
            this.abort(connectListener.future(), t.getCause() == null ? t : t.getCause());
        }
        return connectListener.future();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        Channel channel = ctx.getChannel();
        Object attachment = Channels.getAttachment(channel);
        if (attachment == null) {
            LOGGER.debug("ChannelHandlerContext doesn't have any attachment");
        }
        if (attachment != DiscardEvent.INSTANCE) {
            if (attachment instanceof AsyncCallable) {
                Object message = e.getMessage();
                AsyncCallable ac = (AsyncCallable)attachment;
                if (message instanceof HttpChunk) {
                    if (((HttpChunk)HttpChunk.class.cast(message)).isLast()) {
                        ac.call();
                    }
                } else {
                    ac.call();
                    Channels.setDiscard(channel);
                }
            } else if (attachment instanceof NettyResponseFuture) {
                Protocol p = ctx.getPipeline().get(HTTP_PROCESSOR) != null ? this.httpProtocol : this.webSocketProtocol;
                p.handle(channel, e, (NettyResponseFuture)NettyResponseFuture.class.cast(attachment));
            } else {
                try {
                    ctx.getChannel().close();
                }
                catch (Throwable t) {
                    LOGGER.trace("Closing an orphan channel {}", (Object)ctx.getChannel());
                }
            }
        }
    }

    private Realm kerberosChallenge(List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future, boolean proxyInd) throws NTLMEngineException {
        UriComponents uri = request.getURI();
        String host = request.getVirtualHost() != null ? request.getVirtualHost() : uri.getHost();
        String server = proxyServer == null ? host : proxyServer.getHost();
        try {
            String challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
            return realmBuilder.setUri(uri).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (Throwable throwable) {
            if (NettyAsyncHttpProvider.isNTLM(proxyAuth)) {
                return this.ntlmChallenge(proxyAuth, request, proxyServer, headers, realm, future, proxyInd);
            }
            this.abort(future, throwable);
            return null;
        }
    }

    private String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? "Proxy-Authorization" : "Authorization";
    }

    private void addNTLMAuthorization(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
        headers.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private void addType3NTLMAuthorizationHeader(List<String> auth, FluentCaseInsensitiveStringsMap headers, String username, String password, String domain, String workstation, boolean proxyInd) throws NTLMEngineException {
        headers.remove(this.authorizationHeaderName(proxyInd));
        if (MiscUtils.isNonEmpty(auth) && auth.get(0).startsWith("NTLM ")) {
            String serverChallenge = auth.get(0).trim().substring("NTLM ".length());
            String challengeHeader = ntlmEngine.generateType3Msg(username, password, domain, workstation, serverChallenge);
            this.addNTLMAuthorization(headers, challengeHeader, proxyInd);
        }
    }

    private Realm ntlmChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future, boolean proxyInd) throws NTLMEngineException {
        Realm.RealmBuilder realmBuilder;
        boolean useRealm = proxyServer == null && realm != null;
        String ntlmDomain = useRealm ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
        String ntlmHost = useRealm ? realm.getNtlmHost() : proxyServer.getHost();
        String principal = useRealm ? realm.getPrincipal() : proxyServer.getPrincipal();
        String password = useRealm ? realm.getPassword() : proxyServer.getPassword();
        UriComponents uri = request.getURI();
        if (realm != null && !realm.isNtlmMessageType2Received()) {
            String challengeHeader = ntlmEngine.generateType1Msg(ntlmDomain, ntlmHost);
            this.addNTLMAuthorization(headers, challengeHeader, proxyInd);
            realmBuilder = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setNtlmMessageType2Received(true);
            future.getAndSetAuth(false);
        } else {
            this.addType3NTLMAuthorizationHeader(wwwAuth, headers, principal, password, ntlmDomain, ntlmHost, proxyInd);
            realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()) : new Realm.RealmBuilder().setScheme(Realm.AuthScheme.NTLM);
        }
        return realmBuilder.setUri(uri).setMethodName(request.getMethod()).build();
    }

    private Realm ntlmProxyChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        future.getAndSetAuth(false);
        this.addType3NTLMAuthorizationHeader(wwwAuth, headers, proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getNtlmDomain(), proxyServer.getHost(), true);
        Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder();
        if (realm != null) {
            realmBuilder = realmBuilder.clone(realm);
        }
        return realmBuilder.setUri(request.getURI()).setMethodName(request.getMethod()).build();
    }

    private String getPoolKey(NettyResponseFuture<?> future) {
        return this.getPoolKey(future.getURI(), future.getProxyServer(), future.getConnectionPoolKeyStrategy());
    }

    private String getPoolKey(UriComponents uri, ProxyServer proxy, ConnectionPoolKeyStrategy strategy) {
        String serverPart = strategy.getKey(uri);
        return proxy != null ? proxy.getUrl() + serverPart : serverPart;
    }

    private void drainChannel(Channel channel, NettyResponseFuture<?> future) {
        Channels.setAttachment(channel, this.newDrainCallable(future, channel, future.isKeepAlive(), this.getPoolKey(future)));
    }

    private FilterContext<?> handleIoException(FilterContext<?> fc, NettyResponseFuture<?> future) {
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future, efe);
            }
        }
        return fc;
    }

    private void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) throws IOException {
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        this.drainChannel(channel, future);
        this.nextRequest(newRequest, future);
    }

    private List<String> getNettyHeaderValuesByCaseInsensitiveName(HttpHeaders headers, String name) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry e : headers) {
            if (!((String)e.getKey()).equalsIgnoreCase(name)) continue;
            l.add(((String)e.getValue()).trim());
        }
        return l;
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future) throws IOException {
        this.nextRequest(request, future, true);
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future, boolean useCache) throws IOException {
        this.execute(request, future, useCache, true);
    }

    public void abort(NettyResponseFuture<?> future, Throwable t) {
        Channel channel = future.channel();
        if (channel != null) {
            this.channelManager.closeChannel(channel);
        }
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
        }
        future.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme, String host, int port) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (NettyAsyncHttpProvider.isSecure(scheme)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
                p.addFirst(SSL_HANDLER, (ChannelHandler)this.createSslHandler(host, port));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
        }
        if (NettyAsyncHttpProvider.isWebSocket(scheme)) {
            p.replace(HTTP_PROCESSOR, WS_PROCESSOR, (ChannelHandler)this);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.isClose()) {
            return;
        }
        Channel channel = ctx.getChannel();
        this.channelManager.removeAll(channel);
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            LOGGER.trace("super.channelClosed", (Throwable)ex);
        }
        Object attachment = Channels.getAttachment(channel);
        LOGGER.debug("Channel Closed: {} with attachment {}", (Object)channel, attachment);
        if (attachment instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)attachment;
            Channels.setAttachment(channel, ac.future());
            ac.call();
        } else if (attachment instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)attachment;
            future.touch();
            if (!this.config.getIOExceptionFilters().isEmpty()) {
                FilterContext<?> fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                if ((fc = this.handleIoException(fc, future)).replayRequest() && future.canBeReplay()) {
                    this.replayRequest(future, fc, channel);
                    return;
                }
            }
            Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
            p.onClose(channel, e);
            if (future == null || future.isDone()) {
                this.channelManager.closeChannel(channel);
            } else if (!this.retry(ctx.getChannel(), future)) {
                this.abort(future, REMOTELY_CLOSED_EXCEPTION);
            }
        }
    }

    protected boolean retry(Channel channel, NettyResponseFuture<?> future) {
        Object attachment;
        if (this.isClose()) {
            return false;
        }
        if (future == null && (attachment = Channels.getAttachment(channel)) instanceof NettyResponseFuture) {
            future = (NettyResponseFuture)attachment;
        }
        if (future != null && future.canBeReplay()) {
            future.setState(NettyResponseFuture.STATE.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest());
            if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
            }
            try {
                this.nextRequest(future.getRequest(), future);
                return true;
            }
            catch (IOException iox) {
                future.setState(NettyResponseFuture.STATE.CLOSED);
                future.abort(iox);
                LOGGER.error("Remotely Closed, unable to recover", (Throwable)iox);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", future);
        return false;
    }

    private void markAsDone(NettyResponseFuture<?> future, Channel channel) throws MalformedURLException {
        try {
            future.done();
        }
        catch (Throwable t) {
            LOGGER.debug(t.getMessage(), t);
        }
        if (!future.isKeepAlive() || !channel.isReadable()) {
            this.channelManager.closeChannel(channel);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) throws IOException {
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.drainChannel(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, keepAlive, this.getPoolKey(future));
        }
        this.markAsDone(future, channel);
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler<?> handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler<?> handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseBodyPart c) throws Exception {
        boolean state;
        boolean bl = state = handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
        if (c.closeUnderlyingConnection()) {
            future.setKeepAlive(false);
        }
        return state;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture<?> future;
        Throwable cause;
        Channel channel;
        block17: {
            channel = ctx.getChannel();
            cause = e.getCause();
            future = null;
            if (e.getCause() instanceof PrematureChannelClosureException) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
            }
            try {
                if (cause instanceof ClosedChannelException) {
                    return;
                }
                Object attachment = Channels.getAttachment(channel);
                if (attachment instanceof NettyResponseFuture) {
                    future = (NettyResponseFuture<?>)attachment;
                    future.attachChannel(null, false);
                    future.touch();
                    if (cause instanceof IOException) {
                        if (!this.config.getIOExceptionFilters().isEmpty()) {
                            FilterContext<?> fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                            if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                                this.replayRequest(future, fc, channel);
                                return;
                            }
                        } else {
                            try {
                                channel.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                        LOGGER.debug("Trying to recover from dead Channel: {}", (Object)channel);
                        return;
                    }
                    break block17;
                }
                if (attachment instanceof AsyncCallable) {
                    future = ((AsyncCallable)attachment).future();
                }
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (future != null) {
            try {
                LOGGER.debug("Was unable to recover Future: {}", future);
                this.abort(future, cause);
            }
            catch (Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }
        }
        Protocol p = channel.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
        p.onError(channel, e);
        this.channelManager.closeChannel(channel);
        ctx.sendUpstream((ChannelEvent)e);
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnDisconnectException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("org.jboss.netty.handler.ssl.SslHandler") || !element.getMethodName().equals("channelDisconnected")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnWriteCloseException(cause.getCause());
        }
        return false;
    }

    public static <T> NettyResponseFuture<T> newFuture(UriComponents uri, Request request, AsyncHandler<T> asyncHandler, HttpRequest nettyRequest, AsyncHttpClientConfig config, ProxyServer proxyServer) {
        NettyResponseFuture<T> f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, config.getMaxRequestRetry(), request.getConnectionPoolKeyStrategy(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            f.getAndSetWriteBody(false);
        }
        return f;
    }

    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    private static final boolean validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        return request.getMethod() == "GET" && asyncHandler instanceof WebSocketUpgradeHandler;
    }

    private boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, Request request, HttpResponse response, int statusCode) throws Exception {
        if (AsyncHttpProviderUtils.followRedirect(this.config, request) && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307)) {
            if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                future.getAndSetAuth(false);
                HttpHeaders responseHeaders = response.headers();
                String location = responseHeaders.get("Location");
                UriComponents uri = UriComponents.create(future.getURI(), location);
                if (!uri.equals(future.getURI())) {
                    RequestBuilder nBuilder = new RequestBuilder(future.getRequest());
                    if (this.config.isRemoveQueryParamOnRedirect()) {
                        nBuilder.resetQuery();
                    } else {
                        nBuilder.addQueryParams((List)future.getRequest().getQueryParams());
                    }
                    if (!(statusCode < 302 || statusCode > 303 || statusCode == 302 && this.config.isStrict302Handling())) {
                        nBuilder.setMethod("GET");
                    }
                    boolean initialConnectionKeepAlive = future.isKeepAlive();
                    String initialPoolKey = this.getPoolKey(future);
                    future.setURI(uri);
                    UriComponents newURI = uri;
                    String targetScheme = request.getURI().getScheme();
                    if (targetScheme.equals(WEBSOCKET)) {
                        newURI = newURI.withNewScheme(WEBSOCKET);
                    }
                    if (targetScheme.equals(WEBSOCKET_SSL)) {
                        newURI = newURI.withNewScheme(WEBSOCKET_SSL);
                    }
                    LOGGER.debug("Redirecting to {}", (Object)newURI);
                    List setCookieHeaders = responseHeaders.getAll("Set-Cookie2");
                    if (!MiscUtils.isNonEmpty(setCookieHeaders)) {
                        setCookieHeaders = responseHeaders.getAll("Set-Cookie");
                    }
                    for (String cookieStr : setCookieHeaders) {
                        nBuilder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
                    }
                    AsyncCallable ac = this.newDrainCallable(future, channel, initialConnectionKeepAlive, initialPoolKey);
                    if (response.isChunked()) {
                        Channels.setAttachment(channel, ac);
                    } else {
                        ac.call();
                    }
                    this.nextRequest(((RequestBuilder)nBuilder.setURI(newURI)).build(), future);
                    return true;
                }
            } else {
                throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
            }
        }
        return false;
    }

    private final AsyncCallable newDrainCallable(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final String poolKey) {
        return new AsyncCallable(future){

            public Object call() throws Exception {
                NettyAsyncHttpProvider.this.channelManager.tryToOfferChannelToPool(channel, keepAlive, poolKey);
                return null;
            }
        };
    }

    private final void configureKeepAlive(NettyResponseFuture<?> future, HttpResponse response) {
        String connectionHeader = response.headers().get("Connection");
        future.setKeepAlive(connectionHeader == null || connectionHeader.equalsIgnoreCase("keep-alive"));
    }

    private final boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler handler, Request request, HttpResponseStatus status, HttpResponseHeaders responseHeaders) throws IOException {
        if (!this.config.getResponseFilters().isEmpty()) {
            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(request).responseStatus(status).responseHeaders(responseHeaders).build();
            for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                try {
                    if ((fc = asyncFilter.filter(fc)) != null) continue;
                    throw new NullPointerException("FilterContext is null");
                }
                catch (FilterException efe) {
                    this.abort(future, efe);
                }
            }
            future.setAsyncHandler(fc.getAsyncHandler());
            if (fc.replayRequest()) {
                this.replayRequest(future, fc, channel);
                return true;
            }
        }
        return false;
    }

    private final boolean exitAfterHandling401(final Channel channel, final NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer, RequestBuilder requestBuilder) throws Exception {
        List<String> wwwAuthHeaders;
        if (statusCode == 401 && realm != null && !future.getAndSetAuth(true) && !(wwwAuthHeaders = this.getNettyHeaderValuesByCaseInsensitiveName(response.headers(), "WWW-Authenticate")).isEmpty()) {
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            FluentCaseInsensitiveStringsMap requestHeaders = request.getHeaders();
            if (!wwwAuthHeaders.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(wwwAuthHeaders) || wwwAuthHeaders.contains("Negotiate"))) {
                newRealm = this.ntlmChallenge(wwwAuthHeaders, request, proxyServer, requestHeaders, realm, future, false);
            } else if (wwwAuthHeaders.contains("Negotiate")) {
                newRealm = this.kerberosChallenge(wwwAuthHeaders, request, proxyServer, requestHeaders, realm, future, false);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(request.getURI()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(wwwAuthHeaders.get(0)).build();
            }
            Realm nr = newRealm;
            LOGGER.debug("Sending authentication to {}", (Object)request.getURI());
            final Request nextRequest = ((RequestBuilder)requestBuilder.setHeaders(requestHeaders).setRealm(nr)).build();
            AsyncCallable ac = new AsyncCallable(future){

                public Object call() throws Exception {
                    NettyAsyncHttpProvider.this.drainChannel(channel, future);
                    NettyAsyncHttpProvider.this.nextRequest(nextRequest, future);
                    return null;
                }
            };
            if (future.isKeepAlive() && response.isChunked()) {
                Channels.setAttachment(channel, ac);
            } else {
                ac.call();
            }
            return true;
        }
        return false;
    }

    private final boolean exitAfterHandling407(NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer, RequestBuilder requestBuilder) throws Exception {
        List<String> proxyAuth;
        if (statusCode == 407 && realm != null && !future.getAndSetAuth(true) && !(proxyAuth = this.getNettyHeaderValuesByCaseInsensitiveName(response.headers(), "Proxy-Authenticate")).isEmpty()) {
            LOGGER.debug("Sending proxy authentication to {}", (Object)request.getURI());
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            FluentCaseInsensitiveStringsMap requestHeaders = request.getHeaders();
            if (!proxyAuth.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(proxyAuth) || proxyAuth.contains("Negotiate"))) {
                newRealm = this.ntlmProxyChallenge(proxyAuth, request, proxyServer, requestHeaders, realm, future);
            } else if (proxyAuth.contains("Negotiate")) {
                newRealm = this.kerberosChallenge(proxyAuth, request, proxyServer, requestHeaders, realm, future, true);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(request.getURI()).setMethodName("CONNECT").setTargetProxy(true).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader(proxyAuth.get(0)).build();
            }
            Request req = ((RequestBuilder)requestBuilder.setHeaders(requestHeaders).setRealm(newRealm)).build();
            future.setReuseChannel(true);
            future.setConnectAllowed(true);
            this.nextRequest(req, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling100(Channel channel, NettyResponseFuture<?> future, int statusCode) {
        if (statusCode == 100) {
            future.getAndSetWriteHeaders(false);
            future.getAndSetWriteBody(true);
            this.writeRequest(channel, this.config, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, int statusCode, RequestBuilder requestBuilder, HttpRequest nettyRequest) throws IOException {
        if (nettyRequest.getMethod().equals((Object)HttpMethod.CONNECT) && statusCode == 200) {
            LOGGER.debug("Connected to {}:{}", (Object)proxyServer.getHost(), (Object)proxyServer.getPort());
            if (future.isKeepAlive()) {
                future.attachChannel(channel, true);
            }
            try {
                UriComponents requestURI = request.getURI();
                String scheme = requestURI.getScheme();
                String host = requestURI.getHost();
                int port = AsyncHttpProviderUtils.getDefaultPort(requestURI);
                LOGGER.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)scheme);
                this.upgradeProtocol(channel.getPipeline(), scheme, host, port);
            }
            catch (Throwable ex) {
                this.abort(future, ex);
            }
            Request req = requestBuilder.build();
            future.setReuseChannel(true);
            future.setConnectAllowed(false);
            this.nextRequest(req, future);
            return true;
        }
        return false;
    }

    private final boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, HttpResponseStatus status) throws IOException, Exception {
        if (!future.getAndSetStatusReceived(true) && this.updateStatusAndInterrupt(handler, status)) {
            this.finishUpdate(future, channel, response.isChunked());
            return true;
        }
        return false;
    }

    private final boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, HttpResponseHeaders responseHeaders) throws IOException, Exception {
        if (!response.headers().isEmpty() && this.updateHeadersAndInterrupt(handler, responseHeaders)) {
            this.finishUpdate(future, channel, response.isChunked());
            return true;
        }
        return false;
    }

    private final boolean exitAfterHandlingBody(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler) throws Exception {
        if (!response.isChunked()) {
            this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), response, this, true));
            this.finishUpdate(future, channel, false);
            return true;
        }
        return false;
    }

    private final boolean exitAfterHandlingHead(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, HttpRequest nettyRequest) throws Exception {
        if (nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
            this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), response, this, true));
            this.markAsDone(future, channel);
            this.drainChannel(channel, future);
        }
        return false;
    }

    private final void handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest nettyRequest = future.getNettyRequest();
        Request request = future.getRequest();
        ProxyServer proxyServer = future.getProxyServer();
        LOGGER.debug("\n\nRequest {}\n\nResponse {}\n", (Object)nettyRequest, (Object)response);
        future.setHttpResponse(response);
        this.configureKeepAlive(future, response);
        ResponseStatus status = new ResponseStatus(future.getURI(), response, this);
        ResponseHeaders responseHeaders = new ResponseHeaders(future.getURI(), response, this);
        if (this.exitAfterProcessingFilters(channel, future, response, handler, request, status, responseHeaders)) {
            return;
        }
        RequestBuilder requestBuilder = new RequestBuilder(future.getRequest());
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        int statusCode = response.getStatus().getCode();
        if (this.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer, requestBuilder) || this.exitAfterHandling407(future, response, request, statusCode, realm, proxyServer, requestBuilder) || this.exitAfterHandling100(channel, future, statusCode) || this.exitAfterHandlingRedirect(channel, future, request, response, statusCode) || this.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, requestBuilder, nettyRequest) || this.exitAfterHandlingStatus(channel, future, response, handler, status) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders) || this.exitAfterHandlingBody(channel, future, response, handler) || this.exitAfterHandlingHead(channel, future, response, handler, nettyRequest)) {
            return;
        }
    }

    private final void handleChunk(HttpChunk chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        boolean last = chunk.isLast();
        if (last || this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), null, this, chunk, last))) {
            HttpChunkTrailer chunkTrailer;
            if (chunk instanceof HttpChunkTrailer && !(chunkTrailer = (HttpChunkTrailer)chunk).trailingHeaders().isEmpty()) {
                ResponseHeaders responseHeaders = new ResponseHeaders(future.getURI(), future.getHttpResponse(), this, chunkTrailer);
                this.updateHeadersAndInterrupt(handler, responseHeaders);
            }
            this.finishUpdate(future, channel, !chunk.isLast());
        }
    }

    public boolean isClose() {
        return this.isClose.get();
    }

    public Timeout newTimeout(TimerTask task, long delay) {
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }

    private static boolean isWebSocket(String scheme) {
        return WEBSOCKET.equalsIgnoreCase(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    private static boolean isSecure(String scheme) {
        return HTTPS.equalsIgnoreCase(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    private static boolean isSecure(UriComponents uri) {
        return NettyAsyncHttpProvider.isSecure(uri.getScheme());
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        UTF8 = Charset.forName("UTF-8");
        ntlmEngine = new NTLMEngine();
    }

    private final class WebSocketProtocol
    implements Protocol {
        private static final byte OPCODE_CONT = 0;
        private static final byte OPCODE_TEXT = 1;
        private static final byte OPCODE_BINARY = 2;
        private static final byte OPCODE_UNKNOWN = -1;

        private WebSocketProtocol() {
        }

        private void invokeOnSucces(Channel channel, WebSocketUpgradeHandler h) {
            if (!h.touchSuccess()) {
                try {
                    h.onSuccess(new NettyWebSocket(channel));
                }
                catch (Exception ex) {
                    WebSocketProtocol webSocketProtocol = this;
                    LOGGER.warn("onSuccess unexexpected exception", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Channel channel, MessageEvent e, NettyResponseFuture future) throws Exception {
            WebSocketUpgradeHandler wsUpgradeHandler = (WebSocketUpgradeHandler)future.getAsyncHandler();
            Request request = future.getRequest();
            if (e.getMessage() instanceof HttpResponse) {
                boolean headerOK;
                boolean statusReceived;
                HttpResponse response = (HttpResponse)e.getMessage();
                HttpHeaders nettyResponseHeaders = response.headers();
                ResponseStatus s = new ResponseStatus(future.getURI(), response, NettyAsyncHttpProvider.this);
                ResponseHeaders responseHeaders = new ResponseHeaders(future.getURI(), response, NettyAsyncHttpProvider.this);
                FilterContext fc = new FilterContext.FilterContextBuilder<WebSocket>().asyncHandler(wsUpgradeHandler).request(request).responseStatus(s).responseHeaders(responseHeaders).build();
                for (ResponseFilter asyncFilter : NettyAsyncHttpProvider.this.config.getResponseFilters()) {
                    try {
                        if ((fc = asyncFilter.filter(fc)) != null) continue;
                        throw new NullPointerException("FilterContext is null");
                    }
                    catch (FilterException efe) {
                        NettyAsyncHttpProvider.this.abort(future, efe);
                    }
                }
                future.setAsyncHandler(fc.getAsyncHandler());
                if (fc.replayRequest()) {
                    NettyAsyncHttpProvider.this.replayRequest(future, fc, channel);
                    return;
                }
                future.setHttpResponse(response);
                if (NettyAsyncHttpProvider.this.exitAfterHandlingRedirect(channel, future, request, response, response.getStatus().getCode())) {
                    return;
                }
                org.jboss.netty.handler.codec.http.HttpResponseStatus status = new org.jboss.netty.handler.codec.http.HttpResponseStatus(101, "Web Socket Protocol Handshake");
                boolean validStatus = response.getStatus().equals((Object)status);
                boolean validUpgrade = nettyResponseHeaders.contains("Upgrade");
                String c = nettyResponseHeaders.get("Connection");
                if (c == null) {
                    c = nettyResponseHeaders.get("connection");
                }
                boolean validConnection = c == null ? false : c.equalsIgnoreCase("Upgrade");
                s = new ResponseStatus(future.getURI(), response, NettyAsyncHttpProvider.this);
                boolean bl = statusReceived = wsUpgradeHandler.onStatusReceived(s) == AsyncHandler.STATE.UPGRADE;
                if (!statusReceived) {
                    try {
                        wsUpgradeHandler.onCompleted();
                    }
                    finally {
                        future.done();
                    }
                    return;
                }
                boolean bl2 = headerOK = wsUpgradeHandler.onHeadersReceived(responseHeaders) == AsyncHandler.STATE.CONTINUE;
                if (!(headerOK && validStatus && validUpgrade && validConnection)) {
                    NettyAsyncHttpProvider.this.abort(future, new IOException("Invalid handshake response"));
                    return;
                }
                String accept = nettyResponseHeaders.get("Sec-WebSocket-Accept");
                String key = WebSocketUtil.getAcceptKey(future.getNettyRequest().headers().get("Sec-WebSocket-Key"));
                if (accept == null || !accept.equals(key)) {
                    NettyAsyncHttpProvider.this.abort(future, new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, key)));
                    return;
                }
                channel.getPipeline().replace(NettyAsyncHttpProvider.HTTP_HANDLER, "ws-encoder", (ChannelHandler)new WebSocket08FrameEncoder(true));
                channel.getPipeline().addBefore(NettyAsyncHttpProvider.WS_PROCESSOR, "ws-decoder", (ChannelHandler)new WebSocket08FrameDecoder(false, false));
                this.invokeOnSucces(channel, wsUpgradeHandler);
                future.done();
            } else if (e.getMessage() instanceof WebSocketFrame) {
                this.invokeOnSucces(channel, wsUpgradeHandler);
                WebSocketFrame frame = (WebSocketFrame)e.getMessage();
                int pendingOpcode = -1;
                if (frame instanceof TextWebSocketFrame) {
                    pendingOpcode = 1;
                } else if (frame instanceof BinaryWebSocketFrame) {
                    pendingOpcode = 2;
                }
                HttpChunk webSocketChunk = new HttpChunk(){
                    private ChannelBuffer content;

                    public boolean isLast() {
                        return false;
                    }

                    public ChannelBuffer getContent() {
                        return this.content;
                    }

                    public void setContent(ChannelBuffer content) {
                        this.content = content;
                    }
                };
                if (frame.getBinaryData() != null) {
                    webSocketChunk.setContent(ChannelBuffers.wrappedBuffer((ChannelBuffer)frame.getBinaryData()));
                    ResponseBodyPart rp = new ResponseBodyPart(future.getURI(), null, NettyAsyncHttpProvider.this, webSocketChunk, true);
                    wsUpgradeHandler.onBodyPartReceived(rp);
                    NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(wsUpgradeHandler.onCompleted());
                    if (webSocket != null) {
                        if (pendingOpcode == 2) {
                            webSocket.onBinaryFragment(rp.getBodyPartBytes(), frame.isFinalFragment());
                        } else if (pendingOpcode == 1) {
                            webSocket.onTextFragment(frame.getBinaryData().toString(UTF8), frame.isFinalFragment());
                        }
                        if (frame instanceof CloseWebSocketFrame) {
                            try {
                                Channels.setDiscard(channel);
                                webSocket.onClose(((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getStatusCode(), ((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getReasonText());
                            }
                            finally {
                                wsUpgradeHandler.resetSuccess();
                            }
                        }
                    } else {
                        LOGGER.debug("UpgradeHandler returned a null NettyWebSocket ");
                    }
                }
            } else {
                LOGGER.error("Invalid message {}", e.getMessage());
            }
        }

        public void onError(Channel channel, ExceptionEvent e) {
            try {
                Object attachment = Channels.getAttachment(channel);
                LOGGER.warn("onError {}", (Object)e);
                if (!(attachment instanceof NettyResponseFuture)) {
                    return;
                }
                NettyResponseFuture nettyResponse = (NettyResponseFuture)attachment;
                WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
                if (webSocket != null) {
                    webSocket.onError(e.getCause());
                    webSocket.close();
                }
            }
            catch (Throwable t) {
                LOGGER.error("onError", t);
            }
        }

        public void onClose(Channel channel, ChannelStateEvent e) {
            LOGGER.trace("onClose {}", (Object)e);
            Object attachment = Channels.getAttachment(channel);
            if (attachment instanceof NettyResponseFuture) {
                try {
                    NettyResponseFuture nettyResponse = (NettyResponseFuture)attachment;
                    WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                    h.resetSuccess();
                }
                catch (Throwable t) {
                    LOGGER.error("onError", t);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HttpProtocol
    implements Protocol {
        private HttpProtocol() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Channel channel, MessageEvent e, NettyResponseFuture<?> future) throws Exception {
            if (future.isDone()) {
                NettyAsyncHttpProvider.this.channelManager.closeChannel(channel);
                return;
            }
            future.touch();
            AsyncHandler<?> handler = future.getAsyncHandler();
            Object message = e.getMessage();
            try {
                if (message instanceof HttpResponse) {
                    NettyAsyncHttpProvider.this.handleHttpResponse((HttpResponse)message, channel, future, handler);
                } else if (message instanceof HttpChunk) {
                    NettyAsyncHttpProvider.this.handleChunk((HttpChunk)message, channel, future, handler);
                }
            }
            catch (Exception t) {
                if (t instanceof IOException && !NettyAsyncHttpProvider.this.config.getIOExceptionFilters().isEmpty()) {
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                    if ((fc = NettyAsyncHttpProvider.this.handleIoException(fc, future)).replayRequest()) {
                        NettyAsyncHttpProvider.this.replayRequest(future, fc, channel);
                        return;
                    }
                }
                try {
                    NettyAsyncHttpProvider.this.abort(future, t);
                }
                finally {
                    NettyAsyncHttpProvider.this.finishUpdate(future, channel, false);
                    throw t;
                }
            }
        }

        @Override
        public void onError(Channel channel, ExceptionEvent e) {
        }

        @Override
        public void onClose(Channel channel, ChannelStateEvent e) {
        }
    }

    private static class NettyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        private final ChannelBuffer content;
        private final FileInputStream file;
        private int byteRead = 0;

        public NettyTransferAdapter(FluentCaseInsensitiveStringsMap headers, ChannelBuffer content, File file) throws IOException {
            super(headers);
            this.content = content;
            this.file = file != null ? new FileInputStream(file) : null;
        }

        public void getBytes(byte[] bytes) {
            if (this.content.writableBytes() != 0) {
                this.content.getBytes(this.byteRead, bytes);
                this.byteRead += bytes.length;
            } else if (this.file != null) {
                try {
                    this.byteRead += this.file.read(bytes);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class OptimizedFileRegion
    implements FileRegion {
        private final FileChannel file;
        private final RandomAccessFile raf;
        private final long position;
        private final long count;
        private long byteWritten;

        public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
            this.raf = raf;
            this.file = raf.getChannel();
            this.position = position;
            this.count = count;
        }

        public long getPosition() {
            return this.position;
        }

        public long getCount() {
            return this.count;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            long count = this.count - position;
            if (count < 0L || position < 0L) {
                throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
            }
            if (count == 0L) {
                return 0L;
            }
            long bw = this.file.transferTo(this.position + position, count, target);
            this.byteWritten += bw;
            if (this.byteWritten == this.raf.length()) {
                this.releaseExternalResources();
            }
            return bw;
        }

        public void releaseExternalResources() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close a file.", (Throwable)e);
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close a file.", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future) {
            this.future = future;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler<?> asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler<?> asyncHandler, NettyResponseFuture<?> future) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future;
        }

        public void operationComplete(ChannelFuture cf) {
            boolean startPublishing;
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (cause instanceof IllegalStateException) {
                    LOGGER.debug(cause.getMessage(), cause);
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.debug(ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
                if (cause instanceof ClosedChannelException || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                    }
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.debug(ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
                this.future.abort(cause);
                return;
            }
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : NettyAsyncHttpProvider.this.getConfig().getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
            this.future.touch();
            if (this.asyncHandler instanceof ProgressAsyncHandler) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiscardEvent {
        INSTANCE;

    }
}

