/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.timeout;

import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeoutTimerTask
implements TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutTimerTask.class);
    protected final AtomicBoolean done = new AtomicBoolean();
    protected volatile NettyResponseFuture<?> nettyResponseFuture;
    protected final NettyRequestSender requestSender;
    protected final TimeoutsHolder timeoutsHolder;
    protected final String remoteAddress;

    public TimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder) {
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.timeoutsHolder = timeoutsHolder;
        this.remoteAddress = nettyResponseFuture.getChannelRemoteAddress().toString();
    }

    protected void expire(String message, long time) {
        LOGGER.debug("{} for {} after {} ms", new Object[]{message, this.nettyResponseFuture, time});
        this.requestSender.abort(this.nettyResponseFuture.channel(), this.nettyResponseFuture, new TimeoutException(message));
    }

    public void clean() {
        if (this.done.compareAndSet(false, true)) {
            this.nettyResponseFuture = null;
        }
    }
}

