/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.id;

import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.id.PairwiseSubjectIdentifierGenerator;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public class HashingSubjectIdentifierGenerator
extends PairwiseSubjectIdentifierGenerator {
    public static final String HASH_ALGORITHM = "SHA-256";
    private final Charset charset = Charset.forName("UTF-8");
    private final byte[] salt;

    public HashingSubjectIdentifierGenerator(String salt) throws NoSuchAlgorithmException {
        if (salt == null) {
            throw new IllegalArgumentException("The salt must not be null");
        }
        if (salt.trim().isEmpty()) {
            throw new IllegalArgumentException("The salt string must not be blank or empty");
        }
        this.salt = salt.getBytes(this.charset);
        MessageDigest.getInstance(HASH_ALGORITHM);
    }

    public byte[] saltBytes() {
        return this.salt;
    }

    @Override
    public Subject generate(String sectorIdentifier, Subject localSub) {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        sha256.update(sectorIdentifier.getBytes(this.charset));
        sha256.update(localSub.getValue().getBytes(this.charset));
        byte[] hash = sha256.digest(this.salt);
        return new Subject(Base64.encodeBase64URLSafeString((byte[])hash));
    }
}

