/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private final AuthorizationCode code;
    private final URI redirectURI;

    public AuthorizationCodeGrant(AuthorizationCode code, URI redirectURI) {
        super(GRANT_TYPE);
        if (code == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("code", this.code.getValue());
        if (this.redirectURI != null) {
            params.put("redirect_uri", this.redirectURI.toString());
        }
        return params;
    }

    public static AuthorizationCodeGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
        String codeString = params.get("code");
        if (codeString == null || codeString.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"code\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        AuthorizationCode code = new AuthorizationCode(codeString);
        String redirectURIString = params.get("redirect_uri");
        URI redirectURI = null;
        if (redirectURIString != null) {
            try {
                redirectURI = new URI(redirectURIString);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, e);
            }
        }
        return new AuthorizationCodeGrant(code, redirectURI);
    }
}

