/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.BaseJWEProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AESCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    public static final Map<Integer, Set<JWEAlgorithm>> COMPATIBLE_ALGORITHMS;

    protected AESCryptoProvider() {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.A128KW);
        algs.add(JWEAlgorithm.A192KW);
        algs.add(JWEAlgorithm.A256KW);
        algs.add(JWEAlgorithm.A128GCMKW);
        algs.add(JWEAlgorithm.A192GCMKW);
        algs.add(JWEAlgorithm.A256GCMKW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A192CBC_HS384);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A192GCM);
        methods.add(EncryptionMethod.A256GCM);
        methods.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        methods.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(methods);
        HashMap algsMap = new HashMap();
        HashSet<JWEAlgorithm> bit16Algs = new HashSet<JWEAlgorithm>();
        HashSet<JWEAlgorithm> bit24Algs = new HashSet<JWEAlgorithm>();
        HashSet<JWEAlgorithm> bit32Algs = new HashSet<JWEAlgorithm>();
        bit16Algs.add(JWEAlgorithm.A128GCMKW);
        bit16Algs.add(JWEAlgorithm.A128KW);
        bit24Algs.add(JWEAlgorithm.A192GCMKW);
        bit24Algs.add(JWEAlgorithm.A192KW);
        bit32Algs.add(JWEAlgorithm.A256GCMKW);
        bit32Algs.add(JWEAlgorithm.A256KW);
        algsMap.put(16, Collections.unmodifiableSet(bit16Algs));
        algsMap.put(24, Collections.unmodifiableSet(bit24Algs));
        algsMap.put(32, Collections.unmodifiableSet(bit32Algs));
        COMPATIBLE_ALGORITHMS = Collections.unmodifiableMap(algsMap);
    }
}

