/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.AuthzId;
import com.nimbusds.common.id.BaseIdentifier;
import com.nimbusds.common.id.CID;
import com.nimbusds.common.id.DNIdentity;
import com.nimbusds.common.id.SID;
import com.nimbusds.common.id.UID;
import com.nimbusds.common.id.Username;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class IdentifierExternalizer
implements AdvancedExternalizer<BaseIdentifier> {
    public Set<Class<? extends BaseIdentifier>> getTypeClasses() {
        HashSet<Class<? extends BaseIdentifier>> types = new HashSet<Class<? extends BaseIdentifier>>();
        types.add(SID.class);
        types.add(UID.class);
        types.add(Username.class);
        types.add(CID.class);
        types.add(AuthzId.class);
        types.add(DNIdentity.class);
        return types;
    }

    public Integer getId() {
        return 10000;
    }

    public void writeObject(ObjectOutput objectOutput, BaseIdentifier identifier) throws IOException {
        objectOutput.writeUTF(identifier.getClass().getName());
        objectOutput.writeUTF(identifier.toString());
    }

    public BaseIdentifier readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String className = objectInput.readUTF();
        String value = objectInput.readUTF();
        if (className.equals(SID.class.getName())) {
            return new SID(value);
        }
        if (className.equals(UID.class.getName())) {
            return new UID(value);
        }
        if (className.equals(Username.class.getName())) {
            return new Username(value);
        }
        if (className.equals(CID.class.getName())) {
            return new CID(value);
        }
        if (className.equals(AuthzId.class.getName())) {
            try {
                return AuthzId.parse(value);
            }
            catch (ParseException e) {
                throw new IOException("Invalid AuthzId value: " + e.getMessage(), e);
            }
        }
        if (className.equals(DNIdentity.class.getName())) {
            try {
                return new DNIdentity(new DN(value));
            }
            catch (LDAPException e) {
                throw new IOException("Invalid DN identity value: " + e.getMessage(), e);
            }
        }
        throw new ClassNotFoundException("Class not found: " + className);
    }
}

