/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSONRPC2WebAPIConfiguration
implements LoggableConfiguration {
    public final String responseContentType;
    public static final String DEFAULT_RESPONSE_CONTENT_TYPE = "application/json; charset=utf-8";
    public final boolean exposeExceptions;
    public static final boolean DEFAULT_EXPOSE_EXCEPTIONS = false;
    public final boolean reportRequestProcTime;
    public static final boolean DEFAULT_REPORT_REQUEST_PROC_TIME = false;

    public JSONRPC2WebAPIConfiguration(String prefix, Properties props) throws PropertyParseException {
        ContentType mime;
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            mime = new ContentType(pr.getOptString(prefix + "responseContentType", DEFAULT_RESPONSE_CONTENT_TYPE));
        }
        catch (ParseException e) {
            throw new PropertyParseException("Invalid Content-Type header value", prefix + "responseContentType");
        }
        if (mime.getParameter("charset") == null) {
            mime.setParameter("charset", "utf-8");
        } else if (!mime.getParameter("charset").equalsIgnoreCase("utf-8")) {
            throw new PropertyParseException("The charset parameter of " + prefix + "responseContentType must be UTF-8");
        }
        this.responseContentType = mime.toString();
        this.exposeExceptions = pr.getOptBoolean(prefix + "exposeExceptions", false);
        this.reportRequestProcTime = pr.getOptBoolean(prefix + "reportRequestProcTime", false);
    }

    @Override
    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("[CM2100] Web API HTTP response Content-Type: {}", (Object)this.responseContentType);
        log.info("[CM2101] Web API exposes exception details: {}", (Object)this.exposeExceptions);
        log.info("[CM2102] Web API reports request processing time: {}", (Object)this.reportRequestProcTime);
    }
}

