/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner.barcodedetection;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeGraphicBase;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeLoadingGraphic;", "Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeGraphicBase;", "overlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "loadingAnimator", "Landroid/animation/ValueAnimator;", "(Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;Landroid/animation/ValueAnimator;)V", "boxClockwiseCoordinates", "", "Landroid/graphics/PointF;", "[Landroid/graphics/PointF;", "coordinateOffsetBits", "Landroid/graphics/Point;", "[Landroid/graphics/Point;", "lastPathPoint", "draw", "", "canvas", "Landroid/graphics/Canvas;", "barcodescanner_release"})
public final class BarcodeLoadingGraphic
extends BarcodeGraphicBase {
    private final PointF[] boxClockwiseCoordinates;
    private final Point[] coordinateOffsetBits;
    private final PointF lastPathPoint;
    private final ValueAnimator loadingAnimator;

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Canvas canvas) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        float boxPerimeter = (this.getBoxRect().width() + this.getBoxRect().height()) * (float)2;
        Path path = new Path();
        Object object = this.loadingAnimator.getAnimatedValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
        }
        float offsetLen = boxPerimeter * ((Float)object).floatValue() % boxPerimeter;
        for (i = 0; i < 4; ++i) {
            float edgeLen;
            float f = edgeLen = i % 2 == 0 ? this.getBoxRect().width() : this.getBoxRect().height();
            if (offsetLen <= edgeLen) {
                this.lastPathPoint.x = this.boxClockwiseCoordinates[i].x + (float)this.coordinateOffsetBits[i].x * offsetLen;
                this.lastPathPoint.y = this.boxClockwiseCoordinates[i].y + (float)this.coordinateOffsetBits[i].y * offsetLen;
                path.moveTo(this.lastPathPoint.x, this.lastPathPoint.y);
                break;
            }
            offsetLen -= edgeLen;
        }
        float pathLen = boxPerimeter * 0.3f;
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void j;
            int index = (i + j) % 4;
            int nextIndex = (i + j + 1) % 4;
            float lineLen = Math.abs(this.boxClockwiseCoordinates[nextIndex].x - this.lastPathPoint.x) + Math.abs(this.boxClockwiseCoordinates[nextIndex].y - this.lastPathPoint.y);
            if (lineLen >= pathLen) {
                path.lineTo(this.lastPathPoint.x + pathLen * (float)this.coordinateOffsetBits[index].x, this.lastPathPoint.y + pathLen * (float)this.coordinateOffsetBits[index].y);
                break;
            }
            this.lastPathPoint.x = this.boxClockwiseCoordinates[nextIndex].x;
            this.lastPathPoint.y = this.boxClockwiseCoordinates[nextIndex].y;
            path.lineTo(this.lastPathPoint.x, this.lastPathPoint.y);
            pathLen -= lineLen;
            ++j;
        }
        canvas.drawPath(path, this.getPathPaint());
    }

    public BarcodeLoadingGraphic(@NotNull GraphicOverlay overlay, @NotNull ValueAnimator loadingAnimator) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        Intrinsics.checkParameterIsNotNull((Object)loadingAnimator, (String)"loadingAnimator");
        super(overlay);
        this.loadingAnimator = loadingAnimator;
        this.boxClockwiseCoordinates = new PointF[]{new PointF(this.getBoxRect().left, this.getBoxRect().top), new PointF(this.getBoxRect().right, this.getBoxRect().top), new PointF(this.getBoxRect().right, this.getBoxRect().bottom), new PointF(this.getBoxRect().left, this.getBoxRect().bottom)};
        this.coordinateOffsetBits = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
        this.lastPathPoint = new PointF();
    }
}

