/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner;

import android.util.Log;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.google.common.base.Objects;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.neyogiry.android.barcodescanner.BarcodeScannerView$WhenMappings;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeProcessor;
import com.neyogiry.android.barcodescanner.camera.CameraSource;
import com.neyogiry.android.barcodescanner.camera.CameraSourcePreview;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import com.neyogiry.android.barcodescanner.camera.WorkflowModel;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 !2\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0006\u0010\u001f\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/neyogiry/android/barcodescanner/BarcodeScannerView;", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "barcodeResult", "Lcom/neyogiry/android/barcodescanner/BarcodeScannerView$BarcodeResult;", "cameraSource", "Lcom/neyogiry/android/barcodescanner/camera/CameraSource;", "currentWorkflowState", "Lcom/neyogiry/android/barcodescanner/camera/WorkflowModel$WorkflowState;", "graphicOverlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "preview", "Lcom/neyogiry/android/barcodescanner/camera/CameraSourcePreview;", "workflowModel", "Lcom/neyogiry/android/barcodescanner/camera/WorkflowModel;", "getFlash", "", "onCreate", "", "onDestroy", "onPause", "onResume", "setBarcodeResult", "result", "setFlash", "flag", "setUpWorkflowModel", "startCameraPreview", "stopCameraPreview", "toggleFlash", "BarcodeResult", "Companion", "barcodescanner_release"})
public class BarcodeScannerView {
    private CameraSource cameraSource;
    private CameraSourcePreview preview;
    private GraphicOverlay graphicOverlay;
    private WorkflowModel workflowModel;
    private WorkflowModel.WorkflowState currentWorkflowState;
    private BarcodeResult barcodeResult;
    private final FragmentActivity activity;
    private static final String TAG = "BarcodeScannerView";
    public static final Companion Companion = new Companion(null);

    public final void onCreate(@NotNull CameraSourcePreview preview, @NotNull GraphicOverlay graphicOverlay) {
        GraphicOverlay graphicOverlay2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)preview), (String)"preview");
        Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
        this.preview = preview;
        GraphicOverlay graphicOverlay3 = graphicOverlay;
        BarcodeScannerView barcodeScannerView = this;
        boolean bl = false;
        boolean bl2 = false;
        GraphicOverlay $this$apply = graphicOverlay3;
        boolean bl3 = false;
        this.cameraSource = new CameraSource($this$apply);
        barcodeScannerView.graphicOverlay = graphicOverlay2 = graphicOverlay3;
        this.setUpWorkflowModel();
    }

    public final void onResume() {
        block4: {
            WorkflowModel workflowModel = this.workflowModel;
            if (workflowModel != null) {
                workflowModel.markCameraFrozen();
            }
            this.currentWorkflowState = WorkflowModel.WorkflowState.NOT_STARTED;
            CameraSource cameraSource = this.cameraSource;
            if (cameraSource != null) {
                GraphicOverlay graphicOverlay = this.graphicOverlay;
                if (graphicOverlay == null) {
                    Intrinsics.throwNpe();
                }
                WorkflowModel workflowModel2 = this.workflowModel;
                if (workflowModel2 == null) {
                    Intrinsics.throwNpe();
                }
                cameraSource.setFrameProcessor(new BarcodeProcessor(graphicOverlay, workflowModel2));
            }
            WorkflowModel workflowModel3 = this.workflowModel;
            if (workflowModel3 == null) break block4;
            workflowModel3.setWorkflowState(WorkflowModel.WorkflowState.DETECTING);
        }
    }

    public final void onPause() {
        this.currentWorkflowState = WorkflowModel.WorkflowState.NOT_STARTED;
        this.stopCameraPreview();
    }

    public final void onDestroy() {
        CameraSource cameraSource = this.cameraSource;
        if (cameraSource != null) {
            cameraSource.release();
        }
        this.cameraSource = null;
    }

    public final void setFlash(boolean flag) {
        block0: {
            CameraSource cameraSource = this.cameraSource;
            if (cameraSource == null) break block0;
            cameraSource.updateFlashMode(flag ? "torch" : "off");
        }
    }

    public final boolean getFlash() {
        CameraSource cameraSource = this.cameraSource;
        return cameraSource != null ? cameraSource.getFlash() : false;
    }

    public final void toggleFlash() {
        block0: {
            CameraSource cameraSource = this.cameraSource;
            if (cameraSource == null) break block0;
            cameraSource.toggleFlash();
        }
    }

    public final void setBarcodeResult(@NotNull BarcodeResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        this.barcodeResult = result;
    }

    private final void startCameraPreview() {
        WorkflowModel workflowModel = this.workflowModel;
        if (workflowModel == null) {
            return;
        }
        WorkflowModel workflowModel2 = workflowModel;
        CameraSource cameraSource = this.cameraSource;
        if (cameraSource == null) {
            return;
        }
        CameraSource cameraSource2 = cameraSource;
        if (!workflowModel2.isCameraLive()) {
            try {
                workflowModel2.markCameraLive();
                CameraSourcePreview cameraSourcePreview = this.preview;
                if (cameraSourcePreview != null) {
                    cameraSourcePreview.start(cameraSource2);
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to start camera preview!", (Throwable)e);
                cameraSource2.release();
                this.cameraSource = null;
            }
        }
    }

    private final void stopCameraPreview() {
        block2: {
            WorkflowModel workflowModel = this.workflowModel;
            if (workflowModel == null) {
                return;
            }
            WorkflowModel workflowModel2 = workflowModel;
            if (!workflowModel2.isCameraLive()) break block2;
            workflowModel2.markCameraFrozen();
            CameraSourcePreview cameraSourcePreview = this.preview;
            if (cameraSourcePreview != null) {
                cameraSourcePreview.stop();
            }
        }
    }

    private final void setUpWorkflowModel() {
        block2: {
            WorkflowModel workflowModel = this.workflowModel = (WorkflowModel)ViewModelProviders.of((FragmentActivity)this.activity).get(WorkflowModel.class);
            if (workflowModel == null) {
                Intrinsics.throwNpe();
            }
            workflowModel.getWorkflowState().observe((LifecycleOwner)this.activity, (Observer)new Observer<WorkflowModel.WorkflowState>(this){
                final /* synthetic */ BarcodeScannerView this$0;

                public final void onChanged(WorkflowModel.WorkflowState workflowState) {
                    if (workflowState == null || Objects.equal((Object)((Object)BarcodeScannerView.access$getCurrentWorkflowState$p(this.this$0)), (Object)((Object)workflowState))) {
                        return;
                    }
                    BarcodeScannerView.access$setCurrentWorkflowState$p(this.this$0, workflowState);
                    StringBuilder stringBuilder = new StringBuilder().append("Current workflow state: ");
                    WorkflowModel.WorkflowState workflowState2 = BarcodeScannerView.access$getCurrentWorkflowState$p(this.this$0);
                    if (workflowState2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Log.d((String)"BarcodeScannerView", (String)stringBuilder.append(workflowState2.name()).toString());
                    switch (BarcodeScannerView$WhenMappings.$EnumSwitchMapping$0[workflowState.ordinal()]) {
                        case 1: {
                            BarcodeScannerView.access$startCameraPreview(this.this$0);
                            break;
                        }
                        case 2: {
                            BarcodeScannerView.access$startCameraPreview(this.this$0);
                            break;
                        }
                        case 3: {
                            BarcodeScannerView.access$stopCameraPreview(this.this$0);
                            break;
                        }
                        case 4: 
                        case 5: {
                            BarcodeScannerView.access$stopCameraPreview(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = barcodeScannerView;
                }
            });
            MutableLiveData<FirebaseVisionBarcode> mutableLiveData = this.workflowModel;
            if (mutableLiveData == null || (mutableLiveData = mutableLiveData.getDetectedBarcode()) == null) break block2;
            FragmentActivity fragmentActivity = this.activity;
            if (fragmentActivity == null) {
                Intrinsics.throwNpe();
            }
            mutableLiveData.observe((LifecycleOwner)fragmentActivity, (Observer)new Observer<FirebaseVisionBarcode>(this){
                final /* synthetic */ BarcodeScannerView this$0;

                public final void onChanged(FirebaseVisionBarcode barcode) {
                    block2: {
                        FirebaseVisionBarcode firebaseVisionBarcode = barcode;
                        if (firebaseVisionBarcode == null) break block2;
                        FirebaseVisionBarcode firebaseVisionBarcode2 = firebaseVisionBarcode;
                        boolean bl = false;
                        boolean bl2 = false;
                        FirebaseVisionBarcode it = firebaseVisionBarcode2;
                        boolean bl3 = false;
                        String string = it.getRawValue();
                        if (string != null) {
                            String string2 = string;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String it2 = string2;
                            boolean bl6 = false;
                            Log.i((String)"BarcodeScannerView", (String)("Value " + it2));
                            BarcodeResult barcodeResult = BarcodeScannerView.access$getBarcodeResult$p(this.this$0);
                            if (barcodeResult != null) {
                                String string3 = it2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                                barcodeResult.onBarcodeResult(string3);
                            }
                        }
                    }
                }
                {
                    this.this$0 = barcodeScannerView;
                }
            });
        }
    }

    public BarcodeScannerView(@NotNull FragmentActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.activity = activity;
    }

    public static final /* synthetic */ WorkflowModel.WorkflowState access$getCurrentWorkflowState$p(BarcodeScannerView $this) {
        return $this.currentWorkflowState;
    }

    public static final /* synthetic */ void access$setCurrentWorkflowState$p(BarcodeScannerView $this, WorkflowModel.WorkflowState workflowState) {
        $this.currentWorkflowState = workflowState;
    }

    public static final /* synthetic */ void access$startCameraPreview(BarcodeScannerView $this) {
        $this.startCameraPreview();
    }

    public static final /* synthetic */ void access$stopCameraPreview(BarcodeScannerView $this) {
        $this.stopCameraPreview();
    }

    public static final /* synthetic */ BarcodeResult access$getBarcodeResult$p(BarcodeScannerView $this) {
        return $this.barcodeResult;
    }

    public static final /* synthetic */ void access$setBarcodeResult$p(BarcodeScannerView $this, BarcodeResult barcodeResult) {
        $this.barcodeResult = barcodeResult;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/neyogiry/android/barcodescanner/BarcodeScannerView$BarcodeResult;", "", "onBarcodeResult", "", "value", "", "barcodescanner_release"})
    public static interface BarcodeResult {
        public void onBarcodeResult(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/neyogiry/android/barcodescanner/BarcodeScannerView$Companion;", "", "()V", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

