/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.filetransfer.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nextapp.echo.filetransfer.model.Upload;
import nextapp.echo.filetransfer.model.event.UploadProcessEvent;
import nextapp.echo.filetransfer.model.event.UploadProcessListener;

public class UploadProcess {
    private String id;
    private Set listeners;
    private long size = -1L;
    private List uploadList = new ArrayList();
    private Upload[] uploads = null;
    private boolean canceled = false;

    public UploadProcess(String id) {
        this.id = id;
    }

    public void addProcessListener(UploadProcessListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(l);
    }

    public void cancel() {
        Upload[] uploads = this.getUploads();
        for (int i = 0; i < uploads.length; ++i) {
            uploads[i].cancel();
        }
        if (this.listeners == null) {
            return;
        }
        UploadProcessEvent e = new UploadProcessEvent(this, null);
        UploadProcessListener[] listenerArray = new UploadProcessListener[this.listeners.size()];
        this.listeners.toArray(listenerArray);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].uploadCancel(e);
        }
    }

    public void complete(Upload upload, InputStream in, long size) {
        ((UploadImpl)upload).setSize(size);
        if (upload.getStatus() == 0) {
            ((UploadImpl)upload).setInputStream(in);
            this.notifyComplete(upload);
        } else if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void complete(Upload upload, File file, long size) {
        ((UploadImpl)upload).setSize(size);
        if (upload.getStatus() == 0) {
            ((UploadImpl)upload).setFile(file);
            this.notifyComplete(upload);
        }
    }

    public void configure(Upload upload, String contentType, String fileName) {
        ((UploadImpl)upload).setContentType(contentType);
        ((UploadImpl)upload).setFileName(fileName);
    }

    public Upload createUpload() {
        UploadImpl upload = new UploadImpl();
        this.uploadList.add(upload);
        this.uploads = null;
        return upload;
    }

    public void dispose() {
        this.size = -1L;
        this.uploadList.clear();
        this.uploads = null;
    }

    public synchronized long getProgress() {
        this.getUploads();
        long progress = 0L;
        for (int i = 0; i < this.uploads.length; ++i) {
            progress += this.uploads[i].getProgress();
        }
        return progress;
    }

    public String getId() {
        return this.id;
    }

    public long getSize() {
        return this.size;
    }

    public Upload getUpload() {
        this.getUploads();
        return this.uploads.length == 0 ? null : this.uploads[0];
    }

    public synchronized Upload[] getUploads() {
        if (this.uploads == null) {
            this.uploads = new Upload[this.uploadList.size()];
            this.uploadList.toArray(this.uploads);
        }
        return this.uploads;
    }

    public void init(long size) {
        if (this.size != -1L) {
            throw new IllegalStateException("UploadState already initialized.");
        }
        if (size < 0L) {
            throw new IllegalStateException("Invalid upload size.");
        }
        this.size = size;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean isComplete() {
        this.getUploads();
        for (int i = 0; i < this.uploads.length; ++i) {
            if (this.uploads[i].getStatus() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isInitialized() {
        return this.size != -1L;
    }

    private void notifyComplete(Upload upload) {
        ((UploadImpl)upload).setStatus(1);
        if (this.listeners == null) {
            return;
        }
        UploadProcessEvent e = new UploadProcessEvent(this, upload);
        UploadProcessListener[] listenerArray = new UploadProcessListener[this.listeners.size()];
        this.listeners.toArray(listenerArray);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].uploadComplete(e);
        }
    }

    public void progress(Upload upload, long bytesRead) {
        ((UploadImpl)upload).setProgress(bytesRead);
        if (this.listeners == null) {
            return;
        }
        UploadProcessEvent e = new UploadProcessEvent(this, upload);
        UploadProcessListener[] listenerArray = new UploadProcessListener[this.listeners.size()];
        this.listeners.toArray(listenerArray);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].uploadProgress(e);
        }
    }

    public void removeProcessListener(UploadProcessListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public synchronized void setStatus(int status) {
        Upload[] uploads = this.getUploads();
        for (int i = 0; i < uploads.length; ++i) {
            if (uploads[i].getStatus() != 0) continue;
            ((UploadImpl)uploads[i]).setStatus(status);
        }
    }

    public void start(Upload upload) {
        if (this.listeners == null) {
            return;
        }
        UploadProcessEvent e = new UploadProcessEvent(this, upload);
        UploadProcessListener[] listenerArray = new UploadProcessListener[this.listeners.size()];
        this.listeners.toArray(listenerArray);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].uploadStart(e);
        }
    }

    public String toString() {
        return "UploadProcess: " + this.getProgress() + "/" + this.getSize();
    }

    private class UploadImpl
    implements Upload {
        private File temporaryFile;
        private String contentType;
        private String fileName;
        private InputStream in;
        private long progress;
        private long size;
        private int status;

        private UploadImpl() {
        }

        public void cancel() {
            this.setStatus(2);
        }

        public String getContentType() {
            return this.contentType;
        }

        public File getFile() {
            return this.temporaryFile;
        }

        public String getFileName() {
            return this.fileName;
        }

        public InputStream getInputStream() throws IOException {
            if (this.in == null && this.temporaryFile != null) {
                return new FileInputStream(this.temporaryFile);
            }
            return this.in;
        }

        public long getProgress() {
            return this.progress;
        }

        public long getSize() {
            return this.size;
        }

        public int getStatus() {
            return this.status;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setFile(File file) {
            this.temporaryFile = file;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setProgress(long progress) {
            this.progress = progress;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setStatus(int status) {
            if (this.status == 2) {
                return;
            }
            this.status = status;
        }

        public String toString() {
            return "Upload: ContentType=" + this.contentType + " FileName=" + this.fileName + " Size=" + this.size + " InputStream=" + (this.in == null ? null : this.in.getClass().getName()) + " Progress=" + this.progress / 1000L + "K" + " Status=" + this.status;
        }
    }
}

