/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class EmbeddedJars {
    private static final Map<String, String> EMBEDDED_FORMAT_TO_EXTENSION = EmbeddedJars.getEmbeddedFormatToExtension("ear", "war", "jar");

    private EmbeddedJars() {
    }

    private static Map<String, String> getEmbeddedFormatToExtension(String ... fileExtensions) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (String ext : fileExtensions) {
            builder.put('.' + ext + "!/", ext);
        }
        return builder.build();
    }

    public static InputStream getInputStream(URL url) throws IOException {
        for (Map.Entry<String, String> entry : EMBEDDED_FORMAT_TO_EXTENSION.entrySet()) {
            int index = url.toExternalForm().indexOf(entry.getKey());
            if (index <= 0) continue;
            String path = url.toExternalForm().substring(index + entry.getKey().length());
            InputStream inputStream = (url = new URL(url.toExternalForm().substring(0, index + 1 + entry.getValue().length()))).openStream();
            JarInputStream jarStream = new JarInputStream(inputStream);
            if (!EmbeddedJars.readToEntry(jarStream, path)) {
                inputStream.close();
                throw new IOException("Unable to open stream for " + path + " in " + url.toExternalForm());
            }
            return jarStream;
        }
        return url.openStream();
    }

    private static boolean readToEntry(JarInputStream jarStream, String path) throws IOException {
        JarEntry jarEntry = null;
        while ((jarEntry = jarStream.getNextJarEntry()) != null) {
            if (!path.equals(jarEntry.getName())) continue;
            return true;
        }
        return false;
    }

    static JarInputStream getJarInputStream(URL url) throws IOException {
        boolean isEmbedded = EmbeddedJars.isEmbedded(url);
        InputStream stream = EmbeddedJars.getInputStream(url);
        if (!isEmbedded && stream instanceof JarInputStream) {
            return (JarInputStream)stream;
        }
        return new JarInputStream(stream);
    }

    private static boolean isEmbedded(URL url) {
        String externalForm = url.toExternalForm();
        for (String prefix : EMBEDDED_FORMAT_TO_EXTENSION.keySet()) {
            if (!externalForm.contains(prefix)) continue;
            return true;
        }
        return false;
    }
}

