/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Harvestable;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.TransactionEventsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.StatsWorks;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TransactionEventHarvestableImpl
implements Harvestable {
    public TransactionEventsService transactionEventsService;
    public String appName;
    private long lastHarvest;

    TransactionEventHarvestableImpl(TransactionEventsService transactionEventsService, String appName) {
        this.transactionEventsService = transactionEventsService;
        this.appName = appName;
        this.lastHarvest = System.nanoTime();
    }

    @Override
    public String getEndpointMethodName() {
        return "analytic_event_data";
    }

    @Override
    public void harvest() {
        this.recordIntervalMetric();
        this.transactionEventsService.harvestEvents(this.appName);
    }

    private void recordIntervalMetric() {
        long startTimeInNanos = System.nanoTime();
        final long harvestIntervalInNanos = startTimeInNanos - this.lastHarvest;
        this.lastHarvest = startTimeInNanos;
        ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

            @Override
            public void doWork(StatsEngine statsEngine) {
                if (harvestIntervalInNanos > 0L) {
                    statsEngine.getResponseTimeStats("Supportability/EventHarvest/TransactionEvent/interval").recordResponseTime(harvestIntervalInNanos, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public String getAppName() {
                return TransactionEventHarvestableImpl.this.appName;
            }
        });
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        int maxSamplesConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getTransactionEventsConfig().getMaxSamplesStored();
        Number maxSamplesCollector = (Number)configuration.get("max_samples_stored");
        int maxSamples = maxSamplesCollector != null ? Math.min(maxSamplesCollector.intValue(), maxSamplesConfig) : maxSamplesConfig;
        Number reportPeriod = (Number)configuration.get("report_period_in_seconds");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Events/TransactionEvent/ReportPeriod", reportPeriod.intValue()));
        if (maxSamplesConfig != maxSamples) {
            this.transactionEventsService.updateMaxSamplesStored(maxSamples);
            this.transactionEventsService.harvestPendingEvents();
            this.transactionEventsService.clearReservoirForApp();
        }
    }
}

