/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.language;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.com.google.common.util.concurrent.AtomicLongMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.language.SourceLibraryDetector;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.io.Closeable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SourceLanguageService
extends AbstractService
implements HarvestListener {
    private static final long LANGUAGE_DETECTOR_DELAY_MILLIS = 120000L;
    private static final String UNKNOWN_EXTENSION = "unknown";
    private static final Map<Integer, String> byteCodeVersions = ImmutableMap.builder().put(49, "1.5").put(50, "1.6").put(51, "1.7").put(52, "1.8").put(53, "1.9").put(54, "1.10").put(55, "1.11").build();
    private static final Map<String, String> knownSourceExtensions = ImmutableMap.builder().put("java", "java").put("scala", "scala").put("sc", "scala").put("kt", "kotlin").put("kts", "kotlin").put("clj", "clojure").put("cljs", "clojure").put("cljc", "clojure").put("edn", "clojure").put("groovy", "groovy").build();
    private final AtomicLongMap<String> counts = AtomicLongMap.create();
    private final Set<String> supportabilityKeys = Sets.newHashSet();
    private final SourceLibraryDetector sourceLibraryDetector = new SourceLibraryDetector();
    private Closeable sourceLibraryDetectorCloseable;

    public SourceLanguageService() {
        super(SourceLanguageService.class.getSimpleName());
        for (String byteCodeVersion : byteCodeVersions.values()) {
            for (String knownSourceExtension : knownSourceExtensions.values()) {
                if (this.supportabilityKeys.contains(knownSourceExtension)) continue;
                String supportabilityKey = MessageFormat.format("Supportability/LoadedClasses/{0}/{1}/count", knownSourceExtension, byteCodeVersion);
                this.counts.put(supportabilityKey, 0L);
                this.supportabilityKeys.add(supportabilityKey);
            }
            String supportabilityKey = MessageFormat.format("Supportability/LoadedClasses/{0}/{1}/count", UNKNOWN_EXTENSION, byteCodeVersion);
            this.counts.put(supportabilityKey, 0L);
            this.supportabilityKeys.add(supportabilityKey);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        if (this.isStopped()) {
            return;
        }
        for (String supportabilityKey : this.supportabilityKeys) {
            int currentCount = (int)this.counts.put(supportabilityKey, 0L);
            statsEngine.getResponseTimeStats(supportabilityKey).incrementCallCount(currentCount);
        }
        if (this.sourceLibraryDetector.isDone() && this.sourceLibraryDetectorCloseable != null) {
            this.shutdownLanguageLibraryDetector();
        }
    }

    private void shutdownLanguageLibraryDetector() {
        try {
            Agent.LOG.log(Level.FINEST, "Shutting down source language library sampler");
            this.sourceLibraryDetectorCloseable.close();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, e, "Error shutting down source language library sampler");
        }
        finally {
            this.sourceLibraryDetectorCloseable = null;
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
        this.sourceLibraryDetectorCloseable = ServiceFactory.getSamplerService().addSampler(this.sourceLibraryDetector, 120000L, 240000L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        if (this.sourceLibraryDetectorCloseable != null) {
            this.sourceLibraryDetectorCloseable.close();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void recordSeenMetric(String extension, String version) {
        String supportabilityKey = MessageFormat.format("Supportability/LoadedClasses/{0}/{1}/count", extension, version);
        this.counts.incrementAndGet(supportabilityKey);
    }

    public ClassMatchVisitorFactory getSourceVisitor() {
        return new ClassMatchVisitorFactory(){

            @Override
            public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
                return new ClassVisitor(458752, cv){
                    private String version;
                    private String extension;

                    @Override
                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        super.visit(version, access, name, signature, superName, interfaces);
                        this.version = SourceLanguageService.resolveTargetByteCodeVersion(version);
                    }

                    @Override
                    public void visitSource(String source, String debug) {
                        super.visitSource(source, debug);
                        this.extension = SourceLanguageService.resolveExtension(source);
                    }

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        if (this.version != null) {
                            SourceLanguageService.this.recordSeenMetric(this.extension, this.version);
                        }
                    }
                };
            }
        };
    }

    @VisibleForTesting
    static String resolveTargetByteCodeVersion(int version) {
        return byteCodeVersions.get(version);
    }

    @VisibleForTesting
    static String resolveExtension(String source) {
        String detectedExtension;
        int separatorIndex = SourceLanguageService.findExtensionSeparator(source);
        if (separatorIndex > -1 && knownSourceExtensions.containsKey(detectedExtension = source.substring(separatorIndex + 1).toLowerCase())) {
            return knownSourceExtensions.get(detectedExtension);
        }
        return UNKNOWN_EXTENSION;
    }

    @VisibleForTesting
    Map<String, Long> getSourceCounts() {
        return this.counts.asMap();
    }

    private static int findExtensionSeparator(String source) {
        return source != null ? source.indexOf(".") : -1;
    }
}

