/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableList;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.tracing.ParameterAttributeName;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TransactionName;
import com.newrelic.agent.util.Strings;
import java.util.Arrays;
import java.util.List;

public class TraceDetailsBuilder {
    private String metricPrefix;
    private String metricName;
    private String tracerFactoryName;
    private boolean dispatcher;
    private boolean async;
    private boolean excludeFromTransactionTrace;
    private boolean ignoreTransaction;
    private boolean nameTransaction;
    private boolean custom;
    private boolean webTransaction;
    private TransactionName transactionName;
    private List<InstrumentationType> instrumentationTypes = Lists.newArrayListWithCapacity(3);
    private List<String> instrumentationSourceNames = Lists.newArrayListWithCapacity(3);
    private boolean leaf;
    private final List<String> rollupMetricName = Lists.newArrayListWithCapacity(5);
    public List<ParameterAttributeName> parameterAttributeNames;

    private TraceDetailsBuilder() {
    }

    public static TraceDetailsBuilder newBuilder() {
        return new TraceDetailsBuilder();
    }

    public static TraceDetailsBuilder newBuilder(TraceDetails traceDetails) {
        TraceDetailsBuilder builder = new TraceDetailsBuilder();
        builder.custom = traceDetails.isCustom();
        builder.dispatcher = traceDetails.dispatcher();
        builder.async = traceDetails.async();
        builder.excludeFromTransactionTrace = traceDetails.excludeFromTransactionTrace();
        builder.ignoreTransaction = traceDetails.ignoreTransaction();
        builder.instrumentationSourceNames = Lists.newArrayList(traceDetails.instrumentationSourceNames());
        builder.instrumentationTypes = Lists.newArrayList(traceDetails.instrumentationTypes());
        builder.metricName = traceDetails.metricName();
        builder.metricPrefix = traceDetails.metricPrefix();
        builder.transactionName = traceDetails.transactionName();
        builder.webTransaction = traceDetails.isWebTransaction();
        builder.leaf = traceDetails.isLeaf();
        builder.rollupMetricName.addAll(Arrays.asList(traceDetails.rollupMetricName()));
        builder.parameterAttributeNames = Lists.newArrayList(traceDetails.getParameterAttributeNames());
        return builder;
    }

    public TraceDetails build() {
        return new DefaultTraceDetails(this);
    }

    public TraceDetailsBuilder setParameterAttributeNames(List<ParameterAttributeName> reportedParams) {
        this.parameterAttributeNames = reportedParams;
        return this;
    }

    public TraceDetailsBuilder setMetricPrefix(String metricPrefix) {
        this.metricPrefix = metricPrefix == null ? null : (metricPrefix.endsWith("/") ? metricPrefix.substring(0, metricPrefix.length() - 1) : metricPrefix);
        return this;
    }

    public TraceDetailsBuilder setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public TraceDetailsBuilder setTracerFactoryName(String tracerFactoryName) {
        this.tracerFactoryName = tracerFactoryName;
        return this;
    }

    public TraceDetailsBuilder setDispatcher(boolean dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public TraceDetailsBuilder setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public TraceDetailsBuilder setCustom(boolean custom) {
        this.custom = custom;
        return this;
    }

    public TraceDetailsBuilder setLeaf(boolean leaf) {
        this.leaf = leaf;
        return this;
    }

    public TraceDetailsBuilder setExcludeFromTransactionTrace(boolean excludeFromTransactionTrace) {
        this.excludeFromTransactionTrace = excludeFromTransactionTrace;
        return this;
    }

    public TraceDetailsBuilder setIgnoreTransaction(boolean ignoreTransaction) {
        this.ignoreTransaction = ignoreTransaction;
        return this;
    }

    public TraceDetailsBuilder setNameTransaction(boolean nameTransaction) {
        this.nameTransaction = nameTransaction;
        return this;
    }

    public TraceDetailsBuilder setTransactionName(TransactionNamePriority namingPriority, boolean override, String category, String path) {
        this.transactionName = new TransactionName(namingPriority, override, category, path);
        return this;
    }

    public TraceDetailsBuilder setInstrumentationType(InstrumentationType type) {
        this.instrumentationTypes = type == null ? Lists.newArrayList(InstrumentationType.Unknown) : Lists.newArrayList(type);
        return this;
    }

    public TraceDetailsBuilder setInstrumentationSourceName(String instrumentationSourceName) {
        this.instrumentationSourceNames = instrumentationSourceName == null ? Lists.newArrayList("Unknown") : Lists.newArrayList(instrumentationSourceName);
        return this;
    }

    public TraceDetailsBuilder setWebTransaction(boolean webTransaction) {
        this.webTransaction = webTransaction;
        return this;
    }

    public TraceDetailsBuilder addRollupMetricName(String metricName) {
        this.rollupMetricName.add(metricName);
        return this;
    }

    public TraceDetailsBuilder merge(TraceDetails otherDetails) {
        if (this.metricPrefix == null) {
            this.metricPrefix = otherDetails.metricPrefix();
        }
        if (this.metricName == null) {
            this.metricName = otherDetails.metricName();
        }
        if (this.tracerFactoryName == null) {
            this.tracerFactoryName = otherDetails.tracerFactoryName();
        }
        if (!this.dispatcher) {
            this.dispatcher = otherDetails.dispatcher();
        }
        if (!this.async) {
            this.async = otherDetails.async();
        }
        if (!this.excludeFromTransactionTrace) {
            this.excludeFromTransactionTrace = otherDetails.excludeFromTransactionTrace();
        }
        if (!this.ignoreTransaction && !this.custom) {
            this.ignoreTransaction = otherDetails.ignoreTransaction();
        }
        if (this.transactionName == null) {
            this.transactionName = otherDetails.transactionName();
        }
        if (!this.custom) {
            this.custom = otherDetails.isCustom();
            if (!this.leaf) {
                this.leaf = otherDetails.isLeaf();
            }
        }
        if (!this.webTransaction) {
            this.webTransaction = otherDetails.isWebTransaction();
        }
        this.rollupMetricName.addAll(Arrays.asList(otherDetails.rollupMetricName()));
        this.instrumentationTypes.addAll(otherDetails.instrumentationTypes());
        this.instrumentationSourceNames.addAll(otherDetails.instrumentationSourceNames());
        this.parameterAttributeNames.addAll(otherDetails.getParameterAttributeNames());
        return this;
    }

    public static TraceDetails merge(TraceDetails existing, TraceDetails trace) {
        if (trace.isCustom()) {
            return TraceDetailsBuilder.newBuilder(trace).merge(existing).build();
        }
        return TraceDetailsBuilder.newBuilder(existing).merge(trace).build();
    }

    private static final class DefaultTraceDetails
    implements TraceDetails {
        private final String metricPrefix;
        private final String metricName;
        private final String tracerFactoryName;
        private final TransactionName transactionName;
        private final boolean dispatcher;
        private final boolean async;
        private final boolean excludeFromTransactionTrace;
        private final boolean ignoreTransaction;
        private final boolean custom;
        private final boolean webTransaction;
        private final List<InstrumentationType> instrumentationTypes;
        private final List<String> instrumentationSourceNames;
        private final boolean leaf;
        private final String[] rollupMetricNames;
        private final List<ParameterAttributeName> parameterAttributeNames;

        protected DefaultTraceDetails(TraceDetailsBuilder builder) {
            this.metricName = builder.metricName;
            this.metricPrefix = builder.metricPrefix;
            this.tracerFactoryName = builder.tracerFactoryName;
            this.dispatcher = builder.dispatcher;
            this.async = builder.async;
            this.excludeFromTransactionTrace = builder.excludeFromTransactionTrace;
            this.ignoreTransaction = builder.ignoreTransaction;
            this.custom = builder.custom;
            this.transactionName = builder.nameTransaction ? (this.custom ? TransactionName.CUSTOM_DEFAULT : TransactionName.BUILT_IN_DEFAULT) : builder.transactionName;
            this.instrumentationSourceNames = Lists.newArrayList(builder.instrumentationSourceNames);
            this.instrumentationTypes = Lists.newArrayList(builder.instrumentationTypes);
            this.webTransaction = builder.webTransaction;
            this.leaf = builder.leaf;
            this.rollupMetricNames = builder.rollupMetricName.toArray(new String[0]);
            this.parameterAttributeNames = builder.parameterAttributeNames == null ? ImmutableList.of() : builder.parameterAttributeNames;
        }

        @Override
        public boolean isLeaf() {
            return this.leaf;
        }

        @Override
        public String metricName() {
            return this.metricName;
        }

        @Override
        public boolean dispatcher() {
            return this.dispatcher;
        }

        @Override
        public String tracerFactoryName() {
            return this.tracerFactoryName;
        }

        @Override
        public boolean excludeFromTransactionTrace() {
            return this.excludeFromTransactionTrace;
        }

        @Override
        public boolean async() {
            return this.async;
        }

        @Override
        public String metricPrefix() {
            return this.metricPrefix;
        }

        @Override
        public String getFullMetricName(String className, String methodName) {
            if (this.metricName != null) {
                return this.metricName;
            }
            if (this.metricPrefix == null) {
                return null;
            }
            return Strings.join('/', this.metricPrefix, "${className}", methodName);
        }

        @Override
        public boolean ignoreTransaction() {
            return this.ignoreTransaction;
        }

        @Override
        public boolean isCustom() {
            return this.custom;
        }

        @Override
        public TransactionName transactionName() {
            return this.transactionName;
        }

        @Override
        public List<InstrumentationType> instrumentationTypes() {
            return this.instrumentationTypes;
        }

        @Override
        public List<String> instrumentationSourceNames() {
            return this.instrumentationSourceNames;
        }

        @Override
        public boolean isWebTransaction() {
            return this.webTransaction;
        }

        public String toString() {
            return "DefaultTraceDetails [transactionName=" + this.transactionName + ", dispatcher=" + this.dispatcher + ", custom=" + this.custom + ", instrumentationType=" + this.instrumentationTypes + ", instrumentationSourceName=" + this.instrumentationSourceNames + "]";
        }

        @Override
        public String[] rollupMetricName() {
            return this.rollupMetricNames;
        }

        @Override
        public List<ParameterAttributeName> getParameterAttributeNames() {
            return this.parameterAttributeNames;
        }
    }
}

