/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.http.impl.execchain;

import com.newrelic.agent.deps.org.apache.http.HttpEntity;
import com.newrelic.agent.deps.org.apache.http.HttpResponse;
import com.newrelic.agent.deps.org.apache.http.conn.EofSensorInputStream;
import com.newrelic.agent.deps.org.apache.http.conn.EofSensorWatcher;
import com.newrelic.agent.deps.org.apache.http.entity.HttpEntityWrapper;
import com.newrelic.agent.deps.org.apache.http.impl.execchain.ConnectionHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

class ResponseEntityProxy
extends HttpEntityWrapper
implements EofSensorWatcher {
    private final ConnectionHolder connHolder;

    public static void enchance(HttpResponse response, ConnectionHolder connHolder) {
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.isStreaming() && connHolder != null) {
            response.setEntity(new ResponseEntityProxy(entity, connHolder));
        }
    }

    ResponseEntityProxy(HttpEntity entity, ConnectionHolder connHolder) {
        super(entity);
        this.connHolder = connHolder;
    }

    private void cleanup() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.close();
        }
    }

    private void abortConnection() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.abortConnection();
        }
    }

    public void releaseConnection() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.releaseConnection();
        }
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new EofSensorInputStream(this.wrappedEntity.getContent(), this);
    }

    @Override
    @Deprecated
    public void consumeContent() throws IOException {
        this.releaseConnection();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        try {
            if (outstream != null) {
                this.wrappedEntity.writeTo(outstream);
            }
            this.releaseConnection();
        }
        catch (IOException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.abortConnection();
            throw ex;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean eofDetected(InputStream wrapped) throws IOException {
        try {
            if (wrapped != null) {
                wrapped.close();
            }
            this.releaseConnection();
        }
        catch (IOException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.abortConnection();
            throw ex;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamClosed(InputStream wrapped) throws IOException {
        try {
            boolean open = this.connHolder != null && !this.connHolder.isReleased();
            try {
                if (wrapped != null) {
                    wrapped.close();
                }
                this.releaseConnection();
            }
            catch (SocketException ex) {
                if (open) {
                    throw ex;
                }
            }
        }
        catch (IOException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.abortConnection();
            throw ex;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamAbort(InputStream wrapped) throws IOException {
        this.cleanup();
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResponseEntityProxy{");
        sb.append(this.wrappedEntity);
        sb.append('}');
        return sb.toString();
    }
}

