package com.newrelic.agent.xray;


/**
 * 
 * Objects which need to be notified about X-Ray session creation/destruction need to implement this interface and
 * register for notifications with XRaySessionService via the following call:
 * 
 * ServiceFactory.getXRaySessionService().addListener(this);
 * 
 * 
 */
public interface XRaySessionListener {

    public void xraySessionCreated(XRaySession session);

    public void xraySessionRemoved(XRaySession session);

}
