package com.newrelic.agent.transaction;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;

class SameOrHigherPriorityTransactionNamingPolicy extends TransactionNamingPolicy {

    SameOrHigherPriorityTransactionNamingPolicy() {
    }

    @Override
    public boolean canSetTransactionName(Transaction tx, TransactionNamePriority priority) {
        if (priority == null) {
            return false;
        }
        PriorityTransactionName ptn = tx.getPriorityTransactionName();
        return TransactionNamingUtility.comparePriority(priority, ptn.getPriority(), tx.getNamingScheme()) >= 0;
    }

}
