package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.analytics.SpanEvent;

public final class IgnoreTransactionTracerFactory extends AbstractTracerFactory {
    public final static String TRACER_FACTORY_NAME = IgnoreTransactionTracerFactory.class.getName();

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        transaction.setIgnore(true);
        // we want to add a tracer to the stack to keep the transaction open & skipping child tracers
        return new MethodExitTracerNoSkip(sig, transaction) {
            @Override
            public String getGuid() {
                return null;
            }

            @Override
            protected void doFinish(int opcode, Object returnValue) {

            }
        };
    }
}
