package com.newrelic.agent.stats;

public enum ApdexPerfZone {
    SATISFYING("S"), TOLERATING("T"), FRUSTRATING("F");

    private final String z;

    private ApdexPerfZone(String z) {
        this.z = z;
    }

    public String getZone() {
        return z;
    }

    public static ApdexPerfZone getZone(long responseTimeMillis, long apdexTInMillis) {
        if (responseTimeMillis <= apdexTInMillis) { // record_apdex_s
            return SATISFYING;
        } else if (responseTimeMillis <= 4 * apdexTInMillis) { // record_apdex_t
            return TOLERATING;
        } else { // record_apdex_f
            return FRUSTRATING;
        }
    }
}