package com.newrelic.agent.service.analytics;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CustomInsightsEvent extends AnalyticsEvent {

    private volatile Float priority;

    public CustomInsightsEvent(String type, long timestamp, Map<String, Object> attributes) {
        super(type, timestamp);
        this.userAttributes = attributes;
    }

    public CustomInsightsEvent(String type, long timestamp, Map<String, Object> attributes, float priority) {
        super(type, timestamp, priority);
        this.userAttributes = attributes;
    }

    void setPriority(float priority) {
        this.priority = priority;
    }

    @Override
    public float getPriority() {
        if (priority == null) {
            return super.getPriority();
        }
        return priority;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject intrinsics = new JSONObject();
        intrinsics.put("type", type);
        intrinsics.put("timestamp", timestamp);
        JSONArray.writeJSONString(Arrays.asList(intrinsics, userAttributes), out);
    }

}
