package com.newrelic.agent.service.analytics;

import com.google.common.collect.Maps;

public class ClassHistogramStatsEvent extends BaseInternalCustomEvent {

    private static final String TYPE = "ClassHistogramStatsEvent";

    private final long totalObjects;
    private final long totalSize;

    public ClassHistogramStatsEvent(String appName, long totalObjects, long totalSize) {
        super(appName, TYPE, Maps.<String, Object>newHashMap());

        this.totalObjects = totalObjects;
        this.totalSize = totalSize;

        this.userAttributes.put("totalObjects", totalObjects);
        this.userAttributes.put("totalSize", totalSize);
    }

    public long getTotalObjects() {
        return totalObjects;
    }

    public long getTotalSize() {
        return totalSize;
    }

    @Override
    public String toString() {
        return "ClassHistogramStatsEvent{" +
                "totalObjects=" + totalObjects +
                ", totalSize=" + totalSize +
                '}';
    }

}
