package com.newrelic.agent.service.analytics;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/**
 * This base class should be used any time the agent needs an internal-only custom insights event, so that they can
 * all share the same event service {@link InternalCustomEventService} and reservoir for submitting those events.
 */
public abstract class BaseInternalCustomEvent extends CustomInsightsEvent {

    private final String appName;

    public BaseInternalCustomEvent(String appName, long timestamp, String type, Map<String, Object> attributes) {
        super(type, timestamp, attributes);
        this.appName = appName;
    }

    public BaseInternalCustomEvent(String appName, String type, Map<String, Object> attributes) {
        this(appName, System.currentTimeMillis(), type, attributes);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        super.writeJSONString(out);
    }

    public String getAppName() {
        return appName;
    }

}
