package com.newrelic.agent.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;

/**
 * Pulls the thead id of the current thread and returns it as a string. This will allow the thread id to be printed out
 * to the log format.
 * 
 * @author ashley
 * @since Dec 12, 2012
 * 
 */
public class ThreadIdLogbackConverter extends ClassicConverter {

    /**
     * Returns the thread id of the current thread as a string.
     */
    @Override
    public String convert(ILoggingEvent event) {
        try {
            long theId = Thread.currentThread().getId();
            return Long.toString(theId);
        } catch (Exception e) {
            return null;
        }
    }
}
