package com.newrelic.agent.logging;

import org.slf4j.Marker;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;

public class MarkerLevelConverter extends ClassicConverter {

    /**
     * If a marker is present, then the name of the marker will be used, else the log level will be used.
     * 
     * @param pEvent The current event to be logged.
     */
    @Override
    public String convert(ILoggingEvent pEvent) {
        Marker marker = pEvent.getMarker();
        if (marker == null) {
            return pEvent.getLevel().toString();
        } else {
            return marker.getName();
        }
    }

}
