package com.newrelic.agent.logging;

import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class LogbackMarkers {

    /** String for fine messages. */
    private static String FINE_STR = "FINE";
    /** String for finer messages. */
    private static String FINER_STR = "FINER";
    /** String for finest messages. */
    private static String FINEST_STR = "FINEST";

    /** Used for fine messages. */
    public static final Marker FINE_MARKER = MarkerFactory.getMarker(FINE_STR);
    /** Used for finer messages. */
    public static final Marker FINER_MARKER = MarkerFactory.getMarker(FINER_STR);
    /** Used for finest messages. */
    public static final Marker FINEST_MARKER = MarkerFactory.getMarker(FINEST_STR);

}
