package com.newrelic.agent.logging;

import ch.qos.logback.classic.PatternLayout;

class CustomPatternLogbackLayout extends PatternLayout {

    /** The character representing the thread id. */
    private static final String THREAD_ID_CHAR = "i";
    /** The string representing the marker / level. */
    private static final String MARKER_LEVEL_ID = "ml";

    private static final String PROCESS_ID = "pid";

    /**
     * Creates this CustomPatternLayout.
     * 
     * @param pPattern The pattern for the logger.
     */
    public CustomPatternLogbackLayout(final String pPattern) {
        super();
        defaultConverterMap.put(THREAD_ID_CHAR, ThreadIdLogbackConverter.class.getName());
        defaultConverterMap.put(MARKER_LEVEL_ID, MarkerLevelConverter.class.getName());
        defaultConverterMap.put(PROCESS_ID, ProcessIdLogbackConverter.class.getName());

        setPattern(pPattern);
    }

}
