package com.newrelic.agent.jmx;

public enum JmxType {

    /**
     * A simple JMX metric will record the value for at each minute.
     */
    SIMPLE("simple"),
    /** A monotomically increasing will record the rate of each for each minute. */
    MONOTONICALLY_INCREASING("monotonically_increasing");

    /**
     * Name found in the yml configuration file.
     */
    private String ymlName;

    private JmxType(final String pYmlName) {
        ymlName = pYmlName;
    }

    /**
     * Gets the field ymlName.
     * 
     * @return the ymlName
     */
    public String getYmlName() {
        return ymlName;
    }

}
