package com.newrelic.agent.jmx;

import com.google.common.collect.Maps;
import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.JmxApi;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.values.KafkaConsumerJmxValues;
import com.newrelic.agent.jmx.values.KafkaProducerJmxValues;
import com.newrelic.agent.jmx.values.SolrJmxValues;
import com.newrelic.agent.jmx.values.WebSphere7JmxValues;
import com.newrelic.agent.jmx.values.WebSphereJmxValues;
import com.newrelic.agent.jmx.values.WebsphereLibertyJmxValues;
import com.newrelic.agent.service.ServiceFactory;

import javax.management.MBeanServerFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class JmxApiImpl implements JmxApi {

    private ConcurrentMap<String, Boolean> addedJmx = Maps.newConcurrentMap();

    @Override
    public void addJmxMBeanGroup(String name) {
        if (!addedJmx.containsKey(name)) {
            JmxFrameworkValues jmx = getJmxFrameworkValues(name);
            if (null != jmx) {
                Boolean alreadyAdded = addedJmx.putIfAbsent(name, Boolean.TRUE);
                if (null == alreadyAdded || !alreadyAdded) {
                    ServiceFactory.getJmxService().addJmxFrameworkValues(jmx);
                    Agent.LOG.log(Level.FINE, "Added JMX for {0}", jmx.getPrefix());
                } else {
                    Agent.LOG.log(Level.FINE, "Skipped JMX. Already added JMX framework: {0}", name);
                }
            } else {
                Agent.LOG.log(Level.FINE, "Skipped JMX. Unknown JMX framework: {0}", name);
            }
        }
    }

    private JmxFrameworkValues getJmxFrameworkValues(String prefixName) {
        if (prefixName != null) {
            if (prefixName.equals(KafkaProducerJmxValues.PREFIX)) {
                return new KafkaProducerJmxValues();
            } else if (prefixName.equals(KafkaConsumerJmxValues.PREFIX)) {
                return new KafkaConsumerJmxValues();
            } else if (prefixName.equals(WebSphere7JmxValues.PREFIX)) {
                return new WebSphere7JmxValues();
            } else if (prefixName.equals(WebSphereJmxValues.PREFIX)) {
                return new WebSphereJmxValues();
            } else if (prefixName.equals(SolrJmxValues.PREFIX)) {
                return new SolrJmxValues();
            } else if (prefixName.equals(WebsphereLibertyJmxValues.PREFIX)) {
                return new WebsphereLibertyJmxValues();
            }
        }
        return null;
    }

    public void createMBeanServerIfNeeded() {
        if (System.getProperty("com.sun.management.jmxremote") == null && MBeanServerFactory.findMBeanServer(null).isEmpty()) {
            try {
                MBeanServerFactory.createMBeanServer();
                Agent.LOG.log(Level.INFO, "Created a default MBeanServer");
            } catch (Exception e) {
                Agent.LOG.severe("The JMX Service was unable to create a default MBeanServer");
            }
        }
    }

}
