package com.newrelic.agent.instrumentation.pointcuts.jruby;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;

/**
 * Instruments the trace method on the magic class com.newrelic.api.jruby.JavaAgentBackend, naming it with the
 * METRIC_NAME_ARGUMENT.
 *
 * TODO: Remove this pointcut when custom instrumentation solution is available
 *
 * @author andrew
 *
 */
@PointCut
public class NR_ONLY_JRubyTracerPointCut extends TracerFactoryPointCut {
    private final int METRIC_NAME_ARGUMENT = 2;

    public NR_ONLY_JRubyTracerPointCut(PointCutClassTransformer ct) {
        super(NR_ONLY_JRubyTracerPointCut.class, new ExactClassMatcher("com/newrelic/api/jruby/JavaAgentBackend"),
                new ExactMethodMatcher("trace"));
    }

    @Override
    public Tracer doGetTracer(final Transaction transaction, final ClassMethodSignature sig, final Object object,
                              Object[] args) {
        String metric = args[METRIC_NAME_ARGUMENT].toString();
        return new DefaultTracer(transaction, sig, object, new SimpleMetricNameFormat(metric));
    }

}
