package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import java.util.logging.Level;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.WeblogicJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

@PointCut
public class WeblogicStartUpPointCut extends com.newrelic.agent.instrumentation.PointCut implements
        EntryInvocationHandler {

    private boolean addedJmx = false;

    // JAVA-2717: in 12.2, Oracle changed the return type of weblogic.t3.srvr.T3Srvr.run(String[]), hence the OrMatcher.
    public WeblogicStartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(WeblogicStartUpPointCut.class.getName(), null, true), createClassMatcher(),
                OrMethodMatcher.getMethodMatcher(
                        createExactMethodMatcher("run", "([Ljava/lang/String;)I"), // pre-12.2
                        createExactMethodMatcher("run", "([Ljava/lang/String;)Lweblogic/t3/srvr/T3ServerFuture;")));
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("weblogic/t3/srvr/T3Srvr");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new WeblogicJmxValues());
            addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Weblogic");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

}
