package com.newrelic.agent.instrumentation.pointcuts.container.glassfish;

import java.util.logging.Level;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.GlassfishJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

/**
 * Point cut used to detect glassfish.
 * 
 */
@PointCut
public class Glassfish3StartUpPointCut extends com.newrelic.agent.instrumentation.PointCut implements
        EntryInvocationHandler {

    public static final String GLASSFISH_INSTRUMENTATION_GROUP_NAME = "glassfish_instrumentation";

    private boolean addedJmx = false;

    public Glassfish3StartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(Glassfish3StartUpPointCut.class.getName(),
                GLASSFISH_INSTRUMENTATION_GROUP_NAME, true), createClassMatcher(), createMethodMatcher());
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("com/sun/enterprise/v3/server/SystemTasks");
    }

    private static MethodMatcher createMethodMatcher() {
        return createExactMethodMatcher("postConstruct", "()V");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new GlassfishJmxValues());
            addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Glassfish");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

}
