package com.newrelic.agent.instrumentation.pointcuts;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;

/**
 * Instruments the Quartz system itself (as opposed to jobs run through Quartz).
 * 
 * @author sdaubin
 * 
 */
@PointCut
public class QuartzSystemPointCut extends TracerFactoryPointCut {

    public QuartzSystemPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration("quartz_system"), ExactClassMatcher.or(
                "org/quartz/impl/jdbcjobstore/JobStoreSupport", "org/quartz/simpl/RAMJobStore"),
                createExactMethodMatcher("acquireNextTrigger", "(Lorg/quartz/core/SchedulingContext;)V",
                        "(Lorg/quartz/core/SchedulingContext;J)Lorg/quartz/Trigger;"));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object job, Object[] args) {
        return new QuartzJobTracer(transaction, sig, job);
    }

    @Override
    public boolean isDispatcher() {
        return true;
    }

    private static class QuartzJobTracer extends OtherRootTracer {

        public QuartzJobTracer(Transaction transaction, ClassMethodSignature sig, Object job) {
            super(transaction, sig, job, new ClassMethodMetricNameFormat(sig, job, MetricNames.OTHER_TRANSACTION_JOB));
            transaction.setIgnore(true);
        }

    }

}
