package com.newrelic.agent.instrumentation.custom;

import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.service.ServiceFactory;

public class ClassRetransformer {

    private final InstrumentationContextManager contextManager;
    private final Set<ClassMatchVisitorFactory> matchers;
    private CustomClassTransformer transformer;

    public ClassRetransformer(InstrumentationContextManager contextManager) {
        super();
        this.contextManager = contextManager;
        this.matchers = Sets.newHashSet();
    }

    /**
     * Replaces the entire set of extension matchers.
     * 
     * @param newMatchers
     */
    public synchronized void setClassMethodMatchers(List<ExtensionClassAndMethodMatcher> newMatchers) {
        this.matchers.clear();
        if (transformer != null) {
            matchers.add(transformer.getMatcher());
            transformer.destroy();
        }

        if (newMatchers.isEmpty()) {
            transformer = null;
        } else {
            transformer = new CustomClassTransformer(contextManager, newMatchers);
            matchers.add(transformer.getMatcher());
        }
    }

    /**
     * Appends a set of extension matchers. This is only called by the tests.
     * 
     * @param toAdd
     */
    public synchronized void appendClassMethodMatchers(List<ExtensionClassAndMethodMatcher> toAdd) {
        if (transformer != null) {
            toAdd.addAll(transformer.extensionPointCuts);
        }
        setClassMethodMatchers(toAdd);
    }

    public Set<ClassMatchVisitorFactory> getMatchers() {
        return matchers;
    }
}
