package com.newrelic.agent.instrumentation.classmatchers;

import java.io.IOException;
import java.util.Collection;

import org.objectweb.asm.ClassReader;

/**
 * Matches Class objects and class file bytes.
 * 
 * @author sdaubin
 * 
 */
public abstract class ClassMatcher {
    protected static final String JAVA_LANG_OBJECT_INTERNAL_NAME = "java/lang/Object";

    /**
     * Returns true if the class bytes from the class reader definitely match this matcher.
     * 
     * @param loader
     * @param cr
     * @return
     */
    public abstract boolean isMatch(ClassLoader loader, ClassReader cr);

    /**
     * Return true if the given class matches this rule.
     * 
     * @param clazz
     * @return
     */
    public abstract boolean isMatch(Class<?> clazz);

    public abstract Collection<String> getClassNames();

    public boolean isExactClassMatcher() {
        return false;
    }

    /**
     * This method is overridden by the {@link AbstractClassMatcher} to return a more specific matcher.
     */
    public ClassMatcher getClassMatcher(ClassLoader classLoader) throws IOException {
        return this;
    }
}
