package com.newrelic.agent.install;

import com.newrelic.agent.util.EditableFile;

/**
 * 
 * Agent installer for Glassfish
 * 
 * @author Steve Hudson
 * 
 */

public class GlassfishSelfInstaller extends SelfInstaller {

    // Define constants and regular expressions

    private final String scriptPath = "/config/domain.xml";

    // Script snippets to look for, or add
    private final String agentAlreadySet = "(.*)\\-javaagent:(.*)newrelic.jar(.*)";
    private final String locatorString = "(^.*java-config.*$)";

    /**
     * Adds text like this to domain.xml:
     * 
     * <jvm-options>-javaagent:${com.sun.aas.instanceRoot}/newrelic/newrelic.jar</jvm-options>
     * 
     */
    @Override
    public boolean backupAndEditStartScript(String appServerRootDir) {

        return backupAndEdit(appServerRootDir + getStartScript());

    }

    private boolean backupAndEdit(String fullPathToScript) {

        try {
            EditableFile file = new EditableFile(fullPathToScript);

            // Install the javaagent switch, if it is not already set.
            if (!file.contains(getAgentAlreadySetExpr())) {
                backup(file);
                file.insertAfterLocator(getLocator(), getAgentSettings(), true);
                System.out.println("* Added agent switch to start script " + file.getLocation() + lineSep);

            } else {
                System.out.println("* Did not edit start script " + file.getLocation() + " because:");
                System.out.println("The agent switch is already set" + lineSep);
            }

            return true;

        } catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    @Override
    public String getStartScript() {
        return scriptPath;
    }

    @Override
    public String getAlternateStartScript() {
        return getStartScript();
    }

    @Override
    public String getLocator() {
        return locatorString;
    }

    @Override
    public String getAlternateLocator() {
        return getLocator();
    }

    // TODO Batch scripts need parens escaped with hats
    @Override
    public String getAgentSettings() {
        return "        <jvm-options>-javaagent:\\${com.sun.aas.instanceRoot}/newrelic/newrelic.jar</jvm-options>";
    }

    @Override
    public String getAgentAlreadySetExpr() {
        return agentAlreadySet;
    }

}
