package com.newrelic.agent.errors;

import com.newrelic.agent.transaction.TransactionThrowable;

import java.util.List;

public interface ErrorService {

    List<TracedError> getAndClearTracedErrors();

    void reportErrors(TracedError... tracedErrors);

    boolean isIgnoredError(int responseStatus, Throwable throwable);

    boolean isExpectedError(int responseStatus, TransactionThrowable throwable);

    void reportError(TracedError error);

    boolean useStrippedExceptionReplacement(Throwable throwable);

    void reportHTTPError(String message, int statusCode, String uri);

    void reportException(Throwable throwable);

    void stop();

    void start();

    void addHarvestableToService();

}
