package com.newrelic.agent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.ServiceFactory;

public class DebugFlag {

    private static final Map<String, DebugFlag> flagLookup = new ConcurrentHashMap<String, DebugFlag>();

    public static final DebugFlag TOKEN = new DebugFlag("token");

    private final String key;
    private boolean enabled;

    private DebugFlag(String key) {
        this.key = key;
        this.enabled = ServiceFactory.getConfigService().getDefaultAgentConfig().isDebugEnabled(key);
        flagLookup.put(key, this);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public static void updateEnabledStates(AgentConfig agentConfig) {
        for (DebugFlag flag : flagLookup.values()) {
            flag.enabled = agentConfig.isDebugEnabled(flag.key);
        }
    }

}
