/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;

public class HttpError
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> RESPONSE_MESSAGES = ImmutableMap.builder().put(400, "{0} received a bad request format ({1})").put(401, "An authentication error occurred ({1})").put(403, "An access error occurred ({1})").put(404, "Request not found ({1})").put(405, "HTTP method not allowed ({1})").put(407, "{} received a request lacking proper proxy authentication credentials ({1})").put(408, "Request to {0} timed out ({1})").put(409, "Request could not be completed due to a conflict ({1})").put(410, "Requested resource is no longer available ({1})").put(411, "{0} received a request with no Content-Length specified ({1})").put(413, "The data post was too large ({1})").put(414, "Request-URI is too long ({1})").put(415, "An error occurred serializing data ({1})").put(417, "Expectation set in Expect request-header by agent could not be met ({1})").put(429, "{0} has received too many requests ({1})").put(431, "Request header fields are too large ({1})").put(500, "{0} encountered an internal error ({1})").put(503, "{0} is temporarily unavailable ({1})").build();
    private final int statusCode;
    private final int entitySizeInBytes;

    public HttpError(String message, int statusCode, int entitySizeInBytes) {
        super(message == null ? Integer.toString(statusCode) : message);
        this.statusCode = statusCode;
        this.entitySizeInBytes = entitySizeInBytes;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getEntitySizeInBytes() {
        return this.entitySizeInBytes;
    }

    public static HttpError create(int statusCode, String host, int entitySizeInBytes) {
        String messageFormat = RESPONSE_MESSAGES.get(statusCode);
        if (messageFormat == null) {
            messageFormat = "Received a {1} response from {0}";
        }
        String message = MessageFormat.format(messageFormat, host, statusCode);
        return new HttpError(message, statusCode, entitySizeInBytes);
    }

    public boolean isRetryableError() {
        return this.statusCode != 410;
    }

    public boolean isRequestPayloadTooLarge() {
        return this.statusCode == 413;
    }

    public boolean discardHarvestData() {
        return this.statusCode != 408 && this.statusCode != 429 && this.statusCode != 500 && this.statusCode != 503;
    }
}

