/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.struts;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.util.Invoker;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class StrutsActionConfigMatcherPointCut
extends TracerFactoryPointCut {
    private static final String STRUTS = "Struts";
    private static final String ACTION_CONFIG_MATCHER_CLASS = "org/apache/struts/config/ActionConfigMatcher";
    private static final String GET_PATH = "getPath";

    public StrutsActionConfigMatcherPointCut(PointCutClassTransformer classTransformer) {
        super(StrutsActionConfigMatcherPointCut.class, (ClassMatcher)new ExactClassMatcher(ACTION_CONFIG_MATCHER_CLASS), StrutsActionConfigMatcherPointCut.createExactMethodMatcher("convertActionConfig", "(Ljava/lang/String;Lorg/apache/struts/config/ActionConfig;Ljava/util/Map;)Lorg/apache/struts/config/ActionConfig;"));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object matcher, Object[] args) {
        return new StrutsActionConfigMatcherTracer(transaction, sig, matcher, args);
    }

    private static class StrutsActionConfigMatcherTracer
    extends MethodExitTracer {
        public StrutsActionConfigMatcherTracer(Transaction transaction, ClassMethodSignature sig, Object matcher, Object[] args) {
            super(sig, transaction);
            try {
                Object actionConfig = args[1];
                String wildcardPath = (String)Invoker.invoke(actionConfig, actionConfig.getClass(), StrutsActionConfigMatcherPointCut.GET_PATH, new Object[0]);
                Agent.LOG.finer("Normalizing path using Struts wildcard");
                this.setTransactionName(transaction, wildcardPath);
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", StrutsActionConfigMatcherPointCut.class.getSimpleName(), sig, e);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, e);
                }
                Agent.LOG.finer(msg);
            }
        }

        private void setTransactionName(Transaction transaction, String wildcardPath) {
            if (!transaction.isTransactionNamingEnabled()) {
                return;
            }
            TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
            if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Stuts wildcard", wildcardPath);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(transaction, wildcardPath, StrutsActionConfigMatcherPointCut.STRUTS, TransactionNamePriority.FRAMEWORK);
        }

        @Override
        protected void doFinish(int opcode, Object returnValue) {
        }
    }
}

