/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.HttpParameters;
import com.newrelic.api.agent.NewRelic;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class XmlRpcPointCut
extends TracerFactoryPointCut {
    public XmlRpcPointCut(PointCutClassTransformer classTransformer) {
        super(XmlRpcPointCut.class, (ClassMatcher)new InterfaceMatcher("javax/xml/rpc/Call"), XmlRpcPointCut.createExactMethodMatcher("invoke", "([Ljava/lang/Object;)Ljava/lang/Object;", "(Ljavax/xml/namespace/QName;[Ljava/lang/Object;)Ljava/lang/Object;"));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object call, Object[] args) {
        try {
            String endPoint = (String)call.getClass().getMethod("getTargetEndpointAddress", new Class[0]).invoke(call, new Object[0]);
            try {
                URL url = new URL(endPoint);
                String uri = InstrumentUtils.getURI(url);
                String methodName = sig == null ? "" : sig.getMethodName();
                return new XmlRpcTracer(this, transaction, sig, call, url.getHost(), "XmlRpc", uri, new String[]{methodName});
            }
            catch (MalformedURLException e) {
                Agent.LOG.log(Level.FINE, "Unable to parse the target endpoint address for an XML RPC call", e);
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, "Unable to get the target endpoint address for an XML RPC call", e);
        }
        return null;
    }

    private static final class XmlRpcTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private String uri;
        private String library;

        private XmlRpcTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String uri, String[] operations) {
            super(transaction, sig, object, host, library, uri, operations);
            this.uri = uri;
            this.library = library;
        }

        private void finish() {
            try {
                NewRelic.getAgent().getTracedMethod().reportAsExternal((ExternalParameters)HttpParameters.library((String)this.library).uri(new URI(this.uri)).procedure("invoke").noInboundHeaders().build());
            }
            catch (URISyntaxException e) {
                NewRelic.getAgent().getTracedMethod().reportAsExternal((ExternalParameters)HttpParameters.library((String)this.library).uri(URI.create("http://UnknownHost/")).procedure("invoke").noInboundHeaders().build());
            }
        }

        @Override
        public void finish(int opcode, Object returnValue) {
            this.finish();
            super.finish(opcode, returnValue);
        }

        @Override
        public void finish(Throwable throwable) {
            this.finish();
            super.finish(throwable);
        }
    }
}

