/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ManyClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.NoMatchMatcher;
import com.newrelic.agent.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class OrClassMatcher
extends ManyClassMatcher {
    public OrClassMatcher(ClassMatcher ... matchers) {
        this(Arrays.asList(matchers));
    }

    public OrClassMatcher(Collection<ClassMatcher> matchers) {
        super(OrClassMatcher.getOptimizedClassMatchers(matchers));
    }

    private static Collection<ClassMatcher> getOptimizedClassMatchers(Collection<ClassMatcher> matchers) {
        ArrayList<String> exactMatcherClassNames = new ArrayList<String>(matchers.size());
        LinkedList<ClassMatcher> otherMatchers = new LinkedList<ClassMatcher>();
        for (ClassMatcher matcher : matchers) {
            if (matcher instanceof ExactClassMatcher) {
                exactMatcherClassNames.add(((ExactClassMatcher)matcher).getInternalClassName());
                continue;
            }
            otherMatchers.add(matcher);
        }
        if (exactMatcherClassNames.size() <= 1) {
            return matchers;
        }
        otherMatchers.add(OrClassMatcher.createClassMatcher(exactMatcherClassNames.toArray(new String[exactMatcherClassNames.size()])));
        return otherMatchers;
    }

    @Override
    public boolean isMatch(ClassLoader loader, ClassReader cr) {
        for (ClassMatcher matcher : this.getClassMatchers()) {
            if (!matcher.isMatch(loader, cr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatch(Class<?> clazz) {
        for (ClassMatcher matcher : this.getClassMatchers()) {
            if (!matcher.isMatch(clazz)) continue;
            return true;
        }
        return false;
    }

    public static ClassMatcher getClassMatcher(ClassMatcher ... classMatchers) {
        return OrClassMatcher.getClassMatcher(Arrays.asList(classMatchers));
    }

    public static ClassMatcher getClassMatcher(Collection<ClassMatcher> classMatchers) {
        if ((classMatchers = OrClassMatcher.getOptimizedClassMatchers(classMatchers)).size() == 0) {
            return new NoMatchMatcher();
        }
        if (classMatchers.size() == 1) {
            return classMatchers.iterator().next();
        }
        return new OrClassMatcher(classMatchers);
    }

    static ClassMatcher createClassMatcher(String ... classNames) {
        if (classNames.length == 0) {
            return NoMatchMatcher.MATCHER;
        }
        if (classNames.length == 1) {
            return new ExactClassMatcher(classNames[0]);
        }
        return new StringOrClassMatcher(classNames);
    }

    private static class StringOrClassMatcher
    extends ClassMatcher {
        private final Set<String> internalClassNames = new HashSet<String>();
        private final Set<String> classNames;

        public StringOrClassMatcher(String ... internalClassNames) {
            for (String name : internalClassNames) {
                this.internalClassNames.add(Strings.fixInternalClassName(name));
            }
            this.classNames = new HashSet<String>();
            for (String name : this.internalClassNames) {
                this.classNames.add(name.replace('/', '.'));
            }
        }

        @Override
        public boolean isMatch(ClassLoader loader, ClassReader cr) {
            return this.internalClassNames.contains(cr.getClassName());
        }

        @Override
        public boolean isMatch(Class<?> clazz) {
            return this.classNames.contains(clazz.getName());
        }

        public String toString() {
            return this.classNames.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.internalClassNames == null ? 0 : this.internalClassNames.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringOrClassMatcher other = (StringOrClassMatcher)obj;
            return !(this.internalClassNames == null ? other.internalClassNames != null : !this.internalClassNames.equals(other.internalClassNames));
        }

        @Override
        public boolean isExactClassMatcher() {
            return true;
        }

        @Override
        public Collection<String> getClassNames() {
            return this.internalClassNames;
        }
    }
}

