/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.LAEntry;
import com.newrelic.agent.deps.jregex.MatchIterator;
import com.newrelic.agent.deps.jregex.MatchResult;
import com.newrelic.agent.deps.jregex.MemReg;
import com.newrelic.agent.deps.jregex.Pattern;
import com.newrelic.agent.deps.jregex.SearchEntry;
import com.newrelic.agent.deps.jregex.Term;
import com.newrelic.agent.deps.jregex.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Matcher
implements MatchResult {
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_LASTMATCH = 2;
    public static final int ANCHOR_END = 4;
    public static final int ACCEPT_INCOMPLETE = 8;
    private static Term startAnchor = new Term(18);
    private static Term lastMatchAnchor = new Term(23);
    private Pattern re;
    private int[] counters;
    private MemReg[] memregs;
    private LAEntry[] lookaheads;
    private int counterCount;
    private int memregCount;
    private int lookaheadCount;
    private char[] data;
    private int offset;
    private int end;
    private int wOffset;
    private int wEnd;
    private boolean shared;
    private SearchEntry top;
    private SearchEntry first;
    private SearchEntry defaultEntry;
    private boolean called;
    private int minQueueLength;
    private String cache;
    private int cacheOffset;
    private int cacheLength;
    private MemReg prefixBounds;
    private MemReg suffixBounds;
    private MemReg targetBounds;

    Matcher(Pattern regex) {
        int lookaheadCount;
        int counterCount;
        int i;
        this.re = regex;
        int memregCount = regex.memregs;
        if (memregCount > 0) {
            MemReg[] memregs = new MemReg[memregCount];
            for (i = 0; i < memregCount; ++i) {
                memregs[i] = new MemReg(-1);
            }
            this.memregs = memregs;
        }
        if ((counterCount = regex.counters) > 0) {
            this.counters = new int[counterCount];
        }
        if ((lookaheadCount = regex.lookaheads) > 0) {
            LAEntry[] lookaheads = new LAEntry[lookaheadCount];
            for (i = 0; i < lookaheadCount; ++i) {
                lookaheads[i] = new LAEntry();
            }
            this.lookaheads = lookaheads;
        }
        this.memregCount = memregCount;
        this.counterCount = counterCount;
        this.lookaheadCount = lookaheadCount;
        this.first = new SearchEntry();
        this.defaultEntry = new SearchEntry();
        this.minQueueLength = regex.stringRepr.length() / 2;
    }

    public final void setTarget(Matcher m, int groupId) {
        MemReg mr = m.bounds(groupId);
        if (mr == null) {
            throw new IllegalArgumentException("group #" + groupId + " is not assigned");
        }
        this.data = m.data;
        this.offset = mr.in;
        this.end = mr.out;
        this.cache = m.cache;
        this.cacheLength = m.cacheLength;
        this.cacheOffset = m.cacheOffset;
        if (m != this) {
            this.shared = true;
            m.shared = true;
        }
        this.init();
    }

    public void setTarget(String text) {
        this.setTarget(text, 0, text.length());
    }

    public void setTarget(String text, int start, int len) {
        char[] mychars = this.data;
        if (mychars == null || this.shared || mychars.length < len) {
            this.data = mychars = new char[(int)(1.7f * (float)len)];
            this.shared = false;
        }
        text.getChars(start, len, mychars, 0);
        this.offset = 0;
        this.end = len;
        this.cache = text;
        this.cacheOffset = -start;
        this.cacheLength = text.length();
        this.init();
    }

    public void setTarget(char[] text, int start, int len) {
        this.setTarget(text, start, len, true);
    }

    public final void setTarget(char[] text, int start, int len, boolean shared) {
        this.cache = null;
        this.data = text;
        this.offset = start;
        this.end = start + len;
        this.shared = shared;
        this.init();
    }

    public void setTarget(Reader in, int len) throws IOException {
        int c;
        if (len < 0) {
            this.setAll(in);
            return;
        }
        char[] mychars = this.data;
        boolean shared = this.shared;
        if (mychars == null || shared || mychars.length < len) {
            mychars = new char[len];
            shared = false;
        }
        int count = 0;
        while ((c = in.read(mychars, count, len)) >= 0) {
            count += c;
            if ((len -= c) != 0) continue;
        }
        this.setTarget(mychars, 0, count, shared);
    }

    private void setAll(Reader in) throws IOException {
        int c;
        int free;
        char[] mychars = this.data;
        boolean shared = this.shared;
        if (mychars == null || shared) {
            free = 1024;
            mychars = new char[1024];
            shared = false;
        } else {
            free = mychars.length;
        }
        int count = 0;
        while ((c = in.read(mychars, count, free)) >= 0) {
            count += c;
            if ((free -= c) != 0) continue;
            int newsize = count * 3;
            char[] newchars = new char[newsize];
            System.arraycopy(mychars, 0, newchars, 0, count);
            mychars = newchars;
            free = newsize - count;
            shared = false;
        }
        this.setTarget(mychars, 0, count, shared);
    }

    private final String getString(int start, int end) {
        String src = this.cache;
        if (src != null) {
            int co = this.cacheOffset;
            return src.substring(start - co, end - co);
        }
        int tEnd = this.end;
        int tOffset = this.offset;
        int tLen = tEnd - tOffset;
        char[] data = this.data;
        if (end - start >= tLen / 3) {
            this.cache = src = new String(data, tOffset, tLen);
            this.cacheOffset = tOffset;
            this.cacheLength = tLen;
            return src.substring(start - tOffset, end - tOffset);
        }
        return new String(data, start, end - start);
    }

    public final boolean matchesPrefix() {
        this.setPosition(0);
        return this.search(13);
    }

    public final boolean isStart() {
        return this.matchesPrefix();
    }

    public final boolean matches() {
        if (this.called) {
            this.setPosition(0);
        }
        return this.search(5);
    }

    public final boolean matches(String s) {
        this.setTarget(s);
        return this.search(5);
    }

    public void setPosition(int pos) {
        this.wOffset = this.offset + pos;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public final boolean find() {
        if (this.called) {
            this.skip();
        }
        return this.search(0);
    }

    public final boolean find(int anchors) {
        if (this.called) {
            this.skip();
        }
        return this.search(anchors);
    }

    public MatchIterator findAll() {
        return this.findAll(0);
    }

    public MatchIterator findAll(final int options) {
        return new MatchIterator(){
            private boolean checked = false;
            private boolean hasMore = false;

            public boolean hasMore() {
                if (!this.checked) {
                    this.check();
                }
                return this.hasMore;
            }

            public MatchResult nextMatch() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.checked = false;
                return Matcher.this;
            }

            private final void check() {
                this.hasMore = Matcher.this.find(options);
                this.checked = true;
            }

            public int count() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    return 0;
                }
                int c = 1;
                while (Matcher.this.find(options)) {
                    ++c;
                }
                this.checked = false;
                return c;
            }
        };
    }

    public final boolean proceed() {
        return this.proceed(0);
    }

    public final boolean proceed(int options) {
        if (this.called && this.top == null) {
            ++this.wOffset;
        }
        return this.search(0);
    }

    public final void skip() {
        int we = this.wEnd;
        if (this.wOffset == we) {
            if (this.top == null) {
                ++this.wOffset;
                this.flush();
            }
            return;
        }
        this.wOffset = we < 0 ? 0 : we;
        this.flush();
    }

    private final void init() {
        this.wOffset = this.offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    private final void flush() {
        MemReg mr;
        int i;
        this.top = null;
        this.defaultEntry.reset(0);
        this.first.reset(this.minQueueLength);
        for (i = this.memregs.length - 1; i > 0; --i) {
            mr = this.memregs[i];
            mr.out = -1;
            mr.in = -1;
        }
        for (i = this.memregs.length - 1; i > 0; --i) {
            mr = this.memregs[i];
            mr.out = -1;
            mr.in = -1;
        }
        this.called = false;
    }

    private final void rflush() {
        SearchEntry entry = this.top;
        this.top = null;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        while (entry != null) {
            SearchEntry next = entry.sub;
            SearchEntry.popState(entry, memregs, counters);
            entry = next;
        }
        SearchEntry.popState(this.defaultEntry, memregs, counters);
    }

    public String toString() {
        return this.getString(this.wOffset, this.wEnd);
    }

    public Pattern pattern() {
        return this.re;
    }

    public String target() {
        return this.getString(this.offset, this.end);
    }

    public char[] targetChars() {
        this.shared = true;
        return this.data;
    }

    public int targetStart() {
        return this.offset;
    }

    public int targetEnd() {
        return this.end;
    }

    public char charAt(int i) {
        int in = this.wOffset;
        int out = this.wEnd;
        if (in < 0 || out < in) {
            throw new IllegalStateException("unassigned");
        }
        return this.data[in + i];
    }

    public char charAt(int i, int groupId) {
        MemReg mr = this.bounds(groupId);
        if (mr == null) {
            throw new IllegalStateException("group #" + groupId + " is not assigned");
        }
        int in = mr.in;
        if (i < 0 || i > mr.out - in) {
            throw new StringIndexOutOfBoundsException("" + i);
        }
        return this.data[in + i];
    }

    public final int length() {
        return this.wEnd - this.wOffset;
    }

    public final int start() {
        return this.wOffset - this.offset;
    }

    public final int end() {
        return this.wEnd - this.offset;
    }

    public String prefix() {
        return this.getString(this.offset, this.wOffset);
    }

    public String suffix() {
        return this.getString(this.wEnd, this.end);
    }

    public int groupCount() {
        return this.memregs.length;
    }

    public String group(int n) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return null;
        }
        return this.getString(mr.in, mr.out);
    }

    public String group(String name) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("<" + name + "> isn't defined");
        }
        return this.group(id);
    }

    public boolean getGroup(int n, TextBuffer tb) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        tb.append(this.data, in, mr.out - in);
        return true;
    }

    public boolean getGroup(String name, TextBuffer tb) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, tb);
    }

    public boolean getGroup(int n, StringBuffer sb) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        sb.append(this.data, in, mr.out - in);
        return true;
    }

    public boolean getGroup(String name, StringBuffer sb) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, sb);
    }

    public String[] groups() {
        MemReg[] memregs = this.memregs;
        String[] groups = new String[memregs.length];
        for (int i = 0; i < memregs.length; ++i) {
            MemReg mr = memregs[i];
            int in = mr.in;
            int out = mr.out;
            in = mr.in;
            if (in < 0 || mr.out < in) continue;
            groups[i] = this.getString(in, out);
        }
        return groups;
    }

    public Vector groupv() {
        MemReg[] memregs = this.memregs;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < memregs.length; ++i) {
            MemReg mr = this.bounds(i);
            if (mr == null) {
                v.addElement("empty");
                continue;
            }
            String s = this.getString(mr.in, mr.out);
            v.addElement(s);
        }
        return v;
    }

    private final MemReg bounds(int id) {
        MemReg mr;
        if (id >= 0) {
            mr = this.memregs[id];
        } else {
            switch (id) {
                case -1: {
                    mr = this.prefixBounds;
                    if (mr == null) {
                        this.prefixBounds = mr = new MemReg(-1);
                    }
                    mr.in = this.offset;
                    mr.out = this.wOffset;
                    break;
                }
                case -2: {
                    mr = this.suffixBounds;
                    if (mr == null) {
                        this.suffixBounds = mr = new MemReg(-2);
                    }
                    mr.in = this.wEnd;
                    mr.out = this.end;
                    break;
                }
                case -3: {
                    mr = this.targetBounds;
                    if (mr == null) {
                        this.targetBounds = mr = new MemReg(-3);
                    }
                    mr.in = this.offset;
                    mr.out = this.end;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal group id: " + id + "; must either nonnegative int, or MatchResult.PREFIX, or MatchResult.SUFFIX");
                }
            }
        }
        int in = mr.in;
        if (in < 0 || mr.out < in) {
            return null;
        }
        return mr;
    }

    public final boolean isCaptured() {
        return this.wOffset >= 0 && this.wEnd >= this.wOffset;
    }

    public final boolean isCaptured(int id) {
        return this.bounds(id) != null;
    }

    public final boolean isCaptured(String groupName) {
        Integer id = this.re.groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + groupName + "\"");
        }
        return this.isCaptured(id);
    }

    public final int length(int id) {
        MemReg mr = this.bounds(id);
        return mr.out - mr.in;
    }

    public final int start(int id) {
        return this.bounds((int)id).in - this.offset;
    }

    public final int end(int id) {
        return this.bounds((int)id).out - this.offset;
    }

    private final boolean search(int anchors) {
        int i;
        Term term;
        this.called = true;
        int end = this.end;
        int offset = this.offset;
        char[] data = this.data;
        int wOffset = this.wOffset;
        int wEnd = this.wEnd;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        LAEntry[] lookaheads = this.lookaheads;
        int memregCount = this.memregCount;
        int cntCount = this.counterCount;
        SearchEntry defaultEntry = this.defaultEntry;
        SearchEntry first = this.first;
        SearchEntry top = this.top;
        SearchEntry actual = null;
        boolean matchEnd = (anchors & 4) > 0;
        boolean allowIncomplete = (anchors & 8) > 0;
        Pattern re = this.re;
        Term root = re.root;
        if (top == null) {
            if ((anchors & 1) > 0) {
                term = re.root0;
                root = startAnchor;
            } else if ((anchors & 2) > 0) {
                term = re.root0;
                root = lastMatchAnchor;
            } else {
                term = root;
            }
            i = wOffset;
            actual = first;
            SearchEntry.popState(defaultEntry, memregs, counters);
        } else {
            actual = top;
            top = actual.sub;
            term = actual.term;
            i = actual.index;
            SearchEntry.popState(actual, memregs, counters);
        }
        int cnt = actual.cnt;
        int regLen = actual.regLen;
        block56: while (wOffset <= end) {
            block57: while (true) {
                switch (term.type) {
                    case 8: {
                        int jump = Matcher.find(data, i + term.distance, end, term.target);
                        if (jump < 0) break block56;
                        wOffset = i += jump;
                        if (term.eat) {
                            if (i == end) break;
                            ++i;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 9: {
                        MemReg mr = memregs[term.target.memreg];
                        int sampleOff = mr.in;
                        int sampleLen = mr.out - sampleOff;
                        if (sampleOff < 0 || sampleLen < 0) break;
                        if (sampleLen == 0) {
                            term = term.next;
                            continue block57;
                        }
                        int jump = Matcher.findReg(data, i + term.distance, sampleOff, sampleLen, term.target, end);
                        if (jump < 0) break block56;
                        wOffset = i += jump;
                        if (term.eat && (i += sampleLen) > end) break;
                        term = term.next;
                        continue block57;
                    }
                    case 17: {
                        term = term.next;
                        continue block57;
                    }
                    case 0: {
                        if (i >= end || data[i] != term.c) break;
                        ++i;
                        term = term.next;
                        continue block57;
                    }
                    case 4: {
                        if (i >= end) break;
                        ++i;
                        term = term.next;
                        continue block57;
                    }
                    case 5: {
                        char c;
                        if (i >= end || (c = data[i]) == '\r' || c == '\n') break;
                        ++i;
                        term = term.next;
                        continue block57;
                    }
                    case 19: {
                        if (i < end) break;
                        term = term.next;
                        continue block57;
                    }
                    case 20: {
                        if (i >= end) {
                            term = term.next;
                            continue block57;
                        }
                        boolean matches = i >= end | (i + 1 == end && data[i] == '\n') | (i + 2 == end && data[i] == '\r' && data[i + 1] == '\n');
                        if (!matches) break;
                        term = term.next;
                        continue block57;
                    }
                    case 22: {
                        if (i >= end) {
                            term = term.next;
                            continue block57;
                        }
                        char c = data[i];
                        if (c != '\r' && c != '\n') break;
                        term = term.next;
                        continue block57;
                    }
                    case 18: {
                        if (i == offset) {
                            term = term.next;
                            continue block57;
                        }
                        if (top == null && term == startAnchor) break block56;
                        break;
                    }
                    case 23: {
                        if (i != wEnd) break block56;
                        term = term.next;
                        continue block57;
                    }
                    case 21: {
                        char c;
                        if (i == offset) {
                            term = term.next;
                            continue block57;
                        }
                        if (i >= end || (c = data[i - 1]) != '\n' && (c != '\r' || data[i] == '\n')) break;
                        term = term.next;
                        continue block57;
                    }
                    case 1: {
                        char c;
                        if (i >= end || ((c = data[i]) > '\u00ff' || !term.bitset[c]) ^ term.inverse) break;
                        ++i;
                        term = term.next;
                        continue block57;
                    }
                    case 2: {
                        boolean[] arr;
                        char c;
                        if (i >= end || (arr = term.bitset2[(c = data[i]) >> 8]) == null || !arr[c & 0xFF] ^ term.inverse) break;
                        ++i;
                        term = term.next;
                        continue block57;
                    }
                    case 11: {
                        char c;
                        boolean ch1Meets = false;
                        boolean ch2Meets = false;
                        boolean[] bitset = term.bitset;
                        int j = i - 1;
                        if (j >= offset) {
                            c = data[j];
                            boolean bl = ch1Meets = c < '\u0100' && bitset[c];
                        }
                        if (i < end) {
                            c = data[i];
                            boolean bl = ch2Meets = c < '\u0100' && bitset[c];
                        }
                        if (!(ch1Meets ^ ch2Meets ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 13: {
                        char c;
                        boolean ch1Meets = false;
                        boolean ch2Meets = false;
                        boolean[][] bitset2 = term.bitset2;
                        int j = i - 1;
                        if (j >= offset) {
                            c = data[j];
                            boolean[] bits = bitset2[c >> 8];
                            boolean bl = ch1Meets = bits != null && bits[c & 0xFF];
                        }
                        if (i < end) {
                            c = data[i];
                            boolean[] bits = bitset2[c >> 8];
                            boolean bl = ch2Meets = bits != null && bits[c & 0xFF];
                        }
                        if (!(ch1Meets ^ ch2Meets ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 12: {
                        char c;
                        boolean ch1Meets = false;
                        boolean ch2Meets = false;
                        boolean[] bitset = term.bitset;
                        boolean inv = term.inverse;
                        int j = i - 1;
                        if (j >= offset) {
                            c = data[j];
                            boolean bl = ch1Meets = c < '\u0100' && bitset[c];
                        }
                        if (ch1Meets ^ inv) break;
                        if (i < end) {
                            c = data[i];
                            ch2Meets = c < '\u0100' && bitset[c];
                        }
                        if (!ch2Meets ^ inv) break;
                        term = term.next;
                        continue block57;
                    }
                    case 14: {
                        boolean[] bits;
                        char c;
                        boolean ch1Meets = false;
                        boolean ch2Meets = false;
                        boolean[][] bitset2 = term.bitset2;
                        boolean inv = term.inverse;
                        int j = i - 1;
                        if (j >= offset) {
                            c = data[j];
                            bits = bitset2[c >> 8];
                            boolean bl = ch1Meets = bits != null && bits[c & 0xFF];
                        }
                        if (ch1Meets ^ inv) break;
                        if (i < end) {
                            c = data[i];
                            bits = bitset2[c >> 8];
                            ch2Meets = bits != null && bits[c & 0xFF];
                        }
                        if (!ch2Meets ^ inv) break;
                        term = term.next;
                        continue block57;
                    }
                    case 6: {
                        int rLen;
                        MemReg mr = memregs[term.memreg];
                        int sampleOffset = mr.in;
                        int sampleOutside = mr.out;
                        if (sampleOffset < 0 || (rLen = sampleOutside - sampleOffset) < 0) break;
                        if (rLen == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (i + rLen > end || !Matcher.compareRegions(data, sampleOffset, i, rLen, end)) break;
                        i += rLen;
                        term = term.next;
                        continue block57;
                    }
                    case 7: {
                        int rLen;
                        MemReg mr = memregs[term.memreg];
                        int sampleOffset = mr.in;
                        int sampleOutside = mr.out;
                        if (sampleOffset < 0 || (rLen = sampleOutside - sampleOffset) < 0) break;
                        if (rLen == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (i + rLen > end || !Matcher.compareRegionsI(data, sampleOffset, i, rLen, end)) break;
                        i += rLen;
                        term = term.next;
                        continue block57;
                    }
                    case 45: {
                        cnt = Matcher.repeat(data, i, end, term.target);
                        if (cnt <= 0) {
                            term = term.next;
                            continue block57;
                        }
                        actual.cnt = cnt;
                        actual.term = term.failNext;
                        actual.index = i += cnt;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 46: {
                        cnt = Matcher.repeat(data, i, end, term.target);
                        if (cnt < term.minCount) break;
                        actual.cnt = cnt;
                        actual.term = term.failNext;
                        actual.index = i += cnt;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 47: {
                        int out1 = end;
                        int out2 = i + term.maxCount;
                        cnt = Matcher.repeat(data, i, out1 < out2 ? out1 : out2, term.target);
                        if (cnt < term.minCount) break;
                        actual.cnt = cnt;
                        actual.term = term.failNext;
                        actual.index = i += cnt;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 48: {
                        int bitset;
                        MemReg mr = memregs[term.memreg];
                        int sampleOffset = mr.in;
                        int sampleOutside = mr.out;
                        if (sampleOffset < 0 || (bitset = sampleOutside - sampleOffset) < 0) break;
                        if (bitset == 0) {
                            term = term.next;
                            continue block57;
                        }
                        cnt = 0;
                        while (Matcher.compareRegions(data, i, sampleOffset, bitset, end)) {
                            ++cnt;
                            i += bitset;
                        }
                        if (cnt < term.minCount) break;
                        actual.cnt = cnt;
                        actual.term = term.failNext;
                        actual.index = i;
                        actual.regLen = bitset;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 49: {
                        int bitset;
                        MemReg mr = memregs[term.memreg];
                        int sampleOffset = mr.in;
                        int sampleOutside = mr.out;
                        if (sampleOffset < 0 || (bitset = sampleOutside - sampleOffset) < 0) break;
                        if (bitset == 0) {
                            term = term.next;
                            continue block57;
                        }
                        cnt = 0;
                        for (int countBack = term.maxCount; countBack > 0 && Matcher.compareRegions(data, i, sampleOffset, bitset, end); --countBack) {
                            ++cnt;
                            i += bitset;
                        }
                        if (cnt < term.minCount) break;
                        actual.cnt = cnt;
                        actual.term = term.failNext;
                        actual.index = i;
                        actual.regLen = bitset;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 50: {
                        cnt = actual.cnt;
                        if (cnt <= 0) break;
                        actual.cnt = --cnt;
                        actual.index = --i;
                        actual.term = term;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 51: {
                        cnt = actual.cnt;
                        if (cnt <= term.minCount) break;
                        actual.cnt = --cnt;
                        actual.index = --i;
                        actual.term = term;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 52: {
                        int back;
                        cnt = actual.cnt;
                        int minCnt = term.minCount;
                        if (cnt <= minCnt) break;
                        int start = i + term.distance;
                        if (start > end) {
                            int exceed = start - end;
                            if ((cnt -= exceed) <= minCnt) break;
                            i -= exceed;
                            start = end;
                        }
                        if ((back = Matcher.findBack(data, i + term.distance, cnt - minCnt, term.target)) < 0) break;
                        if ((cnt -= back) <= minCnt) {
                            i -= back;
                            if (term.eat) {
                                ++i;
                            }
                            term = term.next;
                            continue block57;
                        }
                        i -= back;
                        actual.cnt = cnt;
                        actual.index = i++;
                        if (term.eat) {
                            // empty if block
                        }
                        actual.term = term;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 53: {
                        int back;
                        cnt = actual.cnt;
                        int minCnt = term.minCount;
                        if (cnt <= minCnt) break;
                        int start = i + term.distance;
                        if (start > end) {
                            int exceed = start - end;
                            if ((cnt -= exceed) <= minCnt) break;
                            i -= exceed;
                            start = end;
                        }
                        MemReg mr = memregs[term.target.memreg];
                        int sampleOff = mr.in;
                        int sampleLen = mr.out - sampleOff;
                        if (sampleOff < 0 || sampleLen < 0) {
                            actual.cnt = --cnt;
                            actual.index = --i;
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block57;
                        }
                        if (sampleLen == 0) {
                            back = -1;
                        } else {
                            back = Matcher.findBackReg(data, i + term.distance, sampleOff, sampleLen, cnt - minCnt, term.target, end);
                            if (back < 0) break;
                        }
                        actual.cnt = cnt -= back;
                        actual.index = i -= back;
                        if (term.eat) {
                            i += sampleLen;
                        }
                        actual.term = term;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 54: {
                        cnt = actual.cnt;
                        if (cnt <= term.minCount) break;
                        regLen = actual.regLen;
                        actual.cnt = --cnt;
                        actual.index = i -= regLen;
                        actual.term = term;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 15: {
                        int memreg = term.memreg;
                        if (memreg > 0) {
                            memregs[memreg].tmp = i;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 16: {
                        int memreg = term.memreg;
                        if (memreg > 0) {
                            MemReg mr = memregs[memreg];
                            SearchEntry.saveMemregState(top != null ? top : defaultEntry, memreg, mr);
                            mr.in = mr.tmp;
                            mr.out = i;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 39: {
                        int tmp = i - term.distance;
                        if (tmp < offset) break;
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.index = i;
                        i = tmp;
                        le.actual = actual;
                        le.top = top;
                        term = term.next;
                        continue block57;
                    }
                    case 35: 
                    case 43: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.index = i;
                        le.actual = actual;
                        le.top = top;
                        term = term.next;
                        continue block57;
                    }
                    case 36: 
                    case 40: 
                    case 57: 
                    case 59: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        i = le.index;
                        actual = le.actual;
                        top = le.top;
                        term = term.next;
                        continue block57;
                    }
                    case 44: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        actual = le.actual;
                        top = le.top;
                        term = term.next;
                        continue block57;
                    }
                    case 41: {
                        int tmp = i - term.distance;
                        if (tmp < offset) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.actual = actual;
                        le.top = top;
                        actual.term = term.failNext;
                        actual.index = i;
                        i = tmp;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 37: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.actual = actual;
                        le.top = top;
                        actual.term = term.failNext;
                        actual.index = i;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 38: 
                    case 42: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        actual = le.actual;
                        top = le.top;
                        break;
                    }
                    case 58: {
                        int tmp = i - term.distance;
                        if (tmp < offset) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.index = i;
                        le.actual = actual;
                        le.top = top;
                        actual.term = term.failNext;
                        actual.index = i;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        i = tmp;
                        term = term.next;
                        continue block57;
                    }
                    case 56: {
                        LAEntry le = lookaheads[term.lookaheadId];
                        le.index = i;
                        le.actual = actual;
                        le.top = top;
                        actual.term = term.failNext;
                        actual.index = i;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 55: {
                        MemReg mr = memregs[term.memreg];
                        int sampleOffset = mr.in;
                        int sampleOutside = mr.out;
                        if (sampleOffset >= 0 && sampleOutside >= 0 && sampleOutside >= sampleOffset) {
                            term = term.next;
                            continue block57;
                        }
                        term = term.failNext;
                        continue block57;
                    }
                    case 34: {
                        actual.regLen = regLen;
                    }
                    case 33: {
                        actual.cnt = cnt;
                    }
                    case 32: {
                        actual.term = term.failNext;
                        actual.index = i;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 10: {
                        if (matchEnd && i != end) break;
                        this.wOffset = memregs[0].in = wOffset;
                        this.wEnd = memregs[0].out = i;
                        this.top = top;
                        return true;
                    }
                    case 24: {
                        cnt = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 25: {
                        ++cnt;
                        term = term.next;
                        continue block57;
                    }
                    case 26: {
                        if (cnt < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 27: {
                        cnt = actual.cnt;
                        if (cnt >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 28: {
                        int cntreg = term.cntreg;
                        int cntvalue = counters[cntreg];
                        SearchEntry.saveCntState(top != null ? top : defaultEntry, cntreg, cntvalue);
                        counters[cntreg] = ++cntvalue;
                        term = term.next;
                        continue block57;
                    }
                    case 29: {
                        counters[term.cntreg] = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 30: {
                        if (counters[term.cntreg] >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 31: {
                        if (counters[term.cntreg] < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    default: {
                        throw new Error("unknown term type: " + term.type);
                    }
                }
                if (allowIncomplete && i == end) {
                    return true;
                }
                if (top == null) break;
                actual = top;
                top = actual.sub;
                term = actual.term;
                i = actual.index;
                if (!actual.isState) continue;
                SearchEntry.popState(actual, memregs, counters);
            }
            if (defaultEntry.isState) {
                SearchEntry.popState(defaultEntry, memregs, counters);
            }
            term = root;
            i = ++wOffset;
        }
        this.wOffset = wOffset;
        this.top = top;
        return false;
    }

    private static final boolean compareRegions(char[] arr, int off1, int off2, int len, int out) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0) {
            if (arr[p1] != arr[p2]) {
                return false;
            }
            --c;
            --p1;
            --p2;
        }
        return true;
    }

    private static final boolean compareRegionsI(char[] arr, int off1, int off2, int len, int out) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0) {
            char c1 = arr[p1];
            char c2 = arr[p2];
            if (c1 != Character.toLowerCase(c2) && c1 != Character.toUpperCase(c2) && c1 != Character.toTitleCase(c2)) {
                return false;
            }
            --c;
            --p1;
            --p2;
        }
        return true;
    }

    private static final int repeat(char[] data, int off, int out, Term term) {
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] == c; ++i) {
                }
                return i - off;
            }
            case 4: {
                return out - off;
            }
            case 5: {
                char c;
                int i;
                for (i = off; i < out && (c = data[i]) != '\r' && c != '\n'; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                boolean[] arr = term.bitset;
                if (term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr[c]); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr[c]) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                boolean[][] bitset2 = term.bitset2;
                if (term.inverse) {
                    char c;
                    boolean[] arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]); ++i) {
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new Error("this kind of term can't be quantified:" + term.type);
    }

    private static final int find(char[] data, int off, int out, Term term) {
        if (off >= out) {
            return -1;
        }
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] != c; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                boolean[] arr = term.bitset;
                if (!term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr[c]); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr[c]) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                boolean[][] bitset2 = term.bitset2;
                if (!term.inverse) {
                    char c;
                    boolean[] arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]); ++i) {
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new IllegalArgumentException("can't seek this kind of term:" + term.type);
    }

    private static final int findReg(char[] data, int off, int regOff, int regLen, Term term, int out) {
        int i;
        if (off >= out) {
            return -1;
        }
        if (term.type == 6) {
            for (i = off; i < out && !Matcher.compareRegions(data, i, regOff, regLen, out); ++i) {
            }
        } else if (term.type == 7) {
            while (i < out && !Matcher.compareRegionsI(data, i, regOff, regLen, out)) {
                ++i;
            }
        } else {
            throw new IllegalArgumentException("wrong findReg() target:" + term.type);
        }
        return off - i;
    }

    private static final int findBack(char[] data, int off, int maxCount, Term term) {
        switch (term.type) {
            case 0: {
                char c = term.c;
                int i = off;
                int iMin = off - maxCount;
                while (data[--i] != c) {
                    if (i > iMin) continue;
                    return -1;
                }
                return off - i;
            }
            case 1: {
                boolean[] arr = term.bitset;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    while ((c = data[--i]) > '\u00ff' || !arr[c]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    while ((c = data[--i]) <= '\u00ff' && arr[c]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
            case 2: {
                boolean[][] bitset2 = term.bitset2;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    boolean[] arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) == null || !arr[c & 0xFF]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) != null && !arr[c & 0xFF]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
        }
        throw new IllegalArgumentException("can't find this kind of term:" + term.type);
    }

    private static final int findBackReg(char[] data, int off, int regOff, int regLen, int maxCount, Term term, int out) {
        int i = off;
        int iMin = off - maxCount;
        if (term.type == 6) {
            char first = data[regOff];
            ++regOff;
            --regLen;
            while (data[--i] != first || !Matcher.compareRegions(data, i + 1, regOff, regLen, out)) {
                if (i > iMin) continue;
                return -1;
            }
        } else {
            if (term.type == 7) {
                char c = data[regOff];
                char firstLower = Character.toLowerCase(c);
                char firstUpper = Character.toUpperCase(c);
                char firstTitle = Character.toTitleCase(c);
                ++regOff;
                --regLen;
                while ((c = data[--i]) != firstLower && c != firstUpper && c != firstTitle || !Matcher.compareRegionsI(data, i + 1, regOff, regLen, out)) {
                    if (i > iMin) continue;
                    return -1;
                }
                return off - i;
            }
            throw new IllegalArgumentException("wrong findBackReg() target type :" + term.type);
        }
        return off - i;
    }

    public String toString_d() {
        StringBuffer s = new StringBuffer();
        s.append("counters: ");
        s.append(this.counters == null ? 0 : this.counters.length);
        s.append("\r\nmemregs: ");
        s.append(this.memregs.length);
        for (int i = 0; i < this.memregs.length; ++i) {
            s.append("\r\n #" + i + ": [" + this.memregs[i].in + "," + this.memregs[i].out + "](\"" + this.getString(this.memregs[i].in, this.memregs[i].out) + "\")");
        }
        s.append("\r\ndata: ");
        if (this.data != null) {
            s.append(this.data.length);
        } else {
            s.append("[none]");
        }
        s.append("\r\noffset: ");
        s.append(this.offset);
        s.append("\r\nend: ");
        s.append(this.end);
        s.append("\r\nwOffset: ");
        s.append(this.wOffset);
        s.append("\r\nwEnd: ");
        s.append(this.wEnd);
        s.append("\r\nregex: ");
        s.append(this.re);
        return s.toString();
    }
}

