/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deadlock;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.deadlock.DeadLockDetector;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DeadlockDetectorService
extends AbstractService {
    private static final String DEADLOCK_DETECTOR_THREAD_NAME = "New Relic Deadlock Detector";
    private static final long INITIAL_DELAY_IN_SECONDS = 300L;
    private static final long SUBSEQUENT_DELAY_IN_SECONDS = 300L;
    private final ErrorCollectorConfig errorCollectorConfig;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final boolean isEnabled;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile ScheduledFuture<?> deadlockTask;

    public DeadlockDetectorService() {
        super(DeadlockDetectorService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.isEnabled = (Boolean)config.getValue("deadlock_detector.enabled", true);
        this.errorCollectorConfig = config.getErrorCollectorConfig();
        DefaultThreadFactory threadFactory = this.isEnabled ? new DefaultThreadFactory(DEADLOCK_DETECTOR_THREAD_NAME, true) : null;
        this.scheduledExecutor = this.isEnabled ? Executors.newSingleThreadScheduledExecutor(threadFactory) : null;
    }

    @Override
    protected void doStart() {
        if (!this.isEnabled) {
            this.logger.log(Level.FINE, "The Deadlock detector is disabled.");
            return;
        }
        if (!this.threadMXBean.isObjectMonitorUsageSupported()) {
            this.logger.log(Level.FINE, "JVM does not support monitoring of object monitor usage. The Deadlock detector is disabled.");
            return;
        }
        if (!this.threadMXBean.isSynchronizerUsageSupported()) {
            this.logger.log(Level.FINE, "JVM does not support monitoring of ownable synchronizer usage. The Deadlock detector is disabled.");
            return;
        }
        final DeadLockDetector deadlockDetector = this.getDeadlockDetector();
        try {
            deadlockDetector.detectDeadlockedThreads();
        }
        catch (Throwable t) {
            this.logger.log(Level.FINE, t, "Failed to detect deadlocked threads: {0}.  The Deadlock detector is disabled.", t.toString());
            this.logger.log(Level.FINEST, t, t.toString());
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    deadlockDetector.detectDeadlockedThreads();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Failed to detect deadlocked threads: {0}", t.toString());
                    if (DeadlockDetectorService.this.getLogger().isLoggable(Level.FINER)) {
                        DeadlockDetectorService.this.getLogger().log(Level.WARNING, msg, t);
                    }
                    DeadlockDetectorService.this.getLogger().warning(msg);
                }
            }
        };
        this.deadlockTask = this.scheduledExecutor.scheduleWithFixedDelay(SafeWrappers.safeRunnable(runnable), 300L, 300L, TimeUnit.SECONDS);
    }

    @Override
    protected void doStop() {
        if (!this.isEnabled) {
            return;
        }
        if (this.deadlockTask != null) {
            this.deadlockTask.cancel(false);
        }
        this.scheduledExecutor.shutdown();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    private DeadLockDetector getDeadlockDetector() {
        return new DeadLockDetector(this.errorCollectorConfig);
    }
}

