/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.weave.utils.CyclicalStack;

public class CyclicalStackArrayImpl
implements CyclicalStack {
    private long[] stack;
    private int limit;
    private int start;
    private int end;
    private int size;

    public CyclicalStackArrayImpl(int stackSize) {
        this.limit = stackSize;
        this.stack = new long[this.limit];
        this.start = 0;
        this.end = 0;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long push(long methodId) {
        this.stack[this.end] = methodId;
        this.end = (this.end + 1) % this.limit;
        if (this.size == this.limit) {
            this.start = (this.start + 1) % this.limit;
        } else {
            ++this.size;
        }
        return methodId;
    }

    @Override
    public long pop() {
        if (this.size == 0) {
            return -1L;
        }
        this.end = this.end == 0 ? this.limit - 1 : --this.end;
        --this.size;
        return this.stack[this.end];
    }

    @Override
    public long peek() {
        if (this.size == 0) {
            return -1L;
        }
        if (this.end == 0) {
            return this.stack[this.limit - 1];
        }
        return this.stack[this.end - 1];
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

